/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.lang.reflect.Field;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.ConstantAnnotationUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.FieldUtil;
import org.seasar.teeda.extension.annotation.handler.AbstractValidatorAnnotationHandler;

public class ConstantValidatorAnnotationHandler
extends AbstractValidatorAnnotationHandler {
    public void registerValidators(String componentName) {
        this.removeValidators(componentName);
        S2Container container = this.getContainer();
        NamingConvention namingConvention = (NamingConvention)container.getComponent((Object)NamingConvention.class);
        ComponentDef componentDef = container.getComponentDef((Object)componentName);
        Class componentClass = componentDef.getComponentClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)componentClass);
        this.processFields(container, componentClass, componentName, namingConvention, beanDesc);
        this.processSetterMethods(container, componentClass, componentName, namingConvention, beanDesc);
    }

    protected void processFields(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc) {
        Field[] fields = componentClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            this.processField(container, componentClass, componentName, namingConvention, beanDesc, fields[i]);
        }
    }

    protected void processField(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc, Field field) {
        boolean isConstantAnnotation = ConstantAnnotationUtil.isConstantAnnotation((Field)field);
        if (!isConstantAnnotation || !field.getName().endsWith(namingConvention.getValidatorSuffix())) {
            return;
        }
        String fieldString = field.getName();
        int index = fieldString.lastIndexOf("_");
        String fieldName = fieldString.substring(0, index);
        String validatorName = fieldString.substring(index + 1);
        if (!beanDesc.hasPropertyDesc(fieldName) || !container.hasComponentDef((Object)validatorName)) {
            return;
        }
        String s = FieldUtil.getString((Field)field, null);
        Map properties = ConstantAnnotationUtil.convertExpressionToMap((String)s);
        this.registerValidator(componentName, fieldName, validatorName, properties);
    }

    protected void processSetterMethods(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc) {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod()) continue;
            this.processSetterMethod(container, componentClass, componentName, namingConvention, beanDesc, pd);
        }
    }

    protected void processSetterMethod(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc, PropertyDesc propertyDesc) {
    }
}

