/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.internal.RenderPreparable;
import javax.faces.internal.RenderPreparableUtil;
import javax.faces.internal.scope.RedirectScope;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.extension.util.TransactionTokenUtil;

public class THtmlCommandButton
extends HtmlCommandButton
implements RenderPreparable {
    public static final String COMPONENT_TYPE = "org.seasar.teeda.extension.HtmlCommandButton";
    public static final String DEFAULT_RENDERER_TYPE = "org.seasar.teeda.extension.HtmlCommandButton";
    private static final long TIME_DEFAULT = 50000L;
    private Boolean renderJs = null;
    private Long time;

    public THtmlCommandButton() {
        this.setRendererType("org.seasar.teeda.extension.HtmlCommandButton");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (TransactionTokenUtil.isDoOnce(this.getId())) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (TransactionTokenUtil.verify(context)) {
                super.broadcast(event);
            } else {
                String path = RedirectScope.getRedirectingPath((FacesContext)context);
                if (path == null) {
                    path = RedirectScope.getRedirectedPath((FacesContext)context);
                }
                if (path != null) {
                    NavigationHandlerUtil.assertNotAlreadyRedirect((FacesContext)context);
                    NavigationHandlerUtil.redirect((FacesContext)context, (String)path);
                }
                context.renderResponse();
            }
            return;
        }
        super.broadcast(event);
    }

    public boolean isRenderJs() {
        if (this.renderJs != null) {
            return this.renderJs;
        }
        ValueBinding vb = this.getValueBinding("renderJs");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setRenderJs(boolean renderJs) {
        this.renderJs = new Boolean(renderJs);
    }

    public long getTime() {
        if (this.time != null) {
            return this.time;
        }
        ValueBinding vb = this.getValueBinding("time");
        Long v = vb != null ? (Long)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : 50000L;
    }

    public void setTime(long time) {
        this.time = new Long(time);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderJs = (Boolean)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.renderJs};
        return values;
    }

    public void encodePrepare(FacesContext context) throws IOException {
        RenderPreparableUtil.encodePrepareForRenderer((FacesContext)context, (UIComponent)this);
    }
}

