/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.internal.SelectItemsIterator;
import javax.faces.model.SelectItem;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.teeda.extension.component.html.THtmlSelectUtil;

public class THtmlSelectOneMenu
extends HtmlSelectOneMenu {
    public static final String COMPONENT_TYPE = "org.seasar.teeda.extension.HtmlSelectOneMenu";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlSelectOneMenu";
    private String pageName;
    private String labelName;
    private Integer size = null;
    private static final String VALIDATION_FAIL_CSS = "onTeedaError";
    private String errorStyleClass = "onTeedaError";

    public void validate(FacesContext context) {
        super.validate(context);
        THtmlSelectUtil.validate((UIComponent)this);
        Object selected = this.getValue();
        Object page = this.getPage(context);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        if (!beanDesc.hasPropertyDesc(this.getLabelName())) {
            return;
        }
        PropertyDesc labelPd = beanDesc.getPropertyDesc(this.getLabelName());
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)this);
        while (it.hasNext()) {
            SelectItem item = (SelectItem)it.next();
            Object v = item.getValue();
            if (!v.equals(selected)) continue;
            String l = item.getLabel();
            labelPd.setValue(page, (Object)l);
            break;
        }
    }

    private Object getPage(FacesContext context) {
        VariableResolver variableResolver = context.getApplication().getVariableResolver();
        return variableResolver.resolveVariable(context, this.getPageName());
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.pageName, this.labelName, this.errorStyleClass, this.size};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.pageName = (String)values[1];
        this.labelName = (String)values[2];
        this.errorStyleClass = (String)values[3];
        this.size = (Integer)values[4];
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getErrorStyleClass() {
        return this.errorStyleClass;
    }

    public void setErrorStyleClass(String errorStyleClass) {
        this.errorStyleClass = errorStyleClass;
    }

    public int getSize() {
        if (this.size != null) {
            return this.size;
        }
        ValueBinding vb = this.getValueBinding("size");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : 1;
    }

    public void setSize(int size) {
        this.size = new Integer(size);
    }
}

