/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.convert;

import java.math.BigDecimal;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.BigDecimalConverter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.convert.ConvertTargetSelectable;
import org.seasar.teeda.extension.util.BigDecimalFormatUtil;
import org.seasar.teeda.extension.util.ConverterUtil;

public class TBigDecimalConverter
extends BigDecimalConverter
implements ConvertTargetSelectable {
    public static final int SCALE_NONE = -1;
    public static final int ROUNDINGMODE_NONE = -1;
    private String pattern;
    private Integer scale;
    private Integer roundingMode;
    private String target;
    private String[] targets;

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return "";
        }
        try {
            if (value instanceof String) {
                return (String)value;
            }
            BigDecimal decimalValue = (BigDecimal)value;
            if (this.scale != null && this.scale != -1) {
                decimalValue = this.roundingMode != null && this.scale != -1 ? decimalValue.setScale((int)this.scale, this.roundingMode) : decimalValue.setScale(this.scale);
            }
            String pattern = this.getPattern();
            return BigDecimalFormatUtil.format(decimalValue, pattern);
        }
        catch (Exception e) {
            if (!this.isTargetCommandConvert(context, this.targets)) {
                return null;
            }
            throw ConvertUtil.wrappedByConverterException((Throwable)e);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(Integer roundingMode) {
        this.roundingMode = roundingMode;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandConvert(FacesContext context, String[] targets) {
        return ConverterUtil.isTargetCommand(context, targets);
    }
}

