/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.internal.ConvertUtil;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.convert.ConvertTargetSelectable;
import org.seasar.teeda.extension.util.ConverterUtil;

public class TDateTimeConverter
extends DateTimeConverter
implements ConvertTargetSelectable {
    private Integer threshold = null;
    private static final int LAST_CENTURY = 1900;
    private static int defaultCenturyStart = 0;
    private String target;
    protected String[] targets;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        boolean isY2Pattern;
        Date date = null;
        try {
            date = (Date)super.getAsObject(context, component, value);
        }
        catch (ConverterException e) {
            if (!this.isTargetCommandConvert(context, this.targets)) {
                return null;
            }
            throw e;
        }
        if (date == null) {
            return null;
        }
        String pattern = this.getPattern();
        SimpleDateFormat formatter = DateConversionUtil.getDateFormat((String)value, (Locale)this.getLocale());
        if (pattern == null) {
            pattern = formatter.toLocalizedPattern();
        }
        boolean isY4Pattern = pattern.indexOf("yyyy") >= 0;
        boolean bl = isY2Pattern = !isY4Pattern && StringUtil.startsWith((String)pattern, (String)"yy");
        if (!isY2Pattern) {
            return date;
        }
        date = this.adjustDate(date);
        if (this.threshold == null) {
            return date;
        }
        String delim = DateConversionUtil.findDelimiter((String)value);
        if (delim == null) {
            Object[] args = ConvertUtil.createExceptionMessageArgs((UIComponent)component, (String)value);
            throw ConvertUtil.wrappedByConverterException((Converter)this, (FacesContext)context, (Object[])args);
        }
        if (delim != null) {
            this.setPattern("yyyy" + delim + "MM" + delim + "dd");
        }
        int start = this.getPattern().indexOf("yyyy");
        value = this.getAsString(context, component, date);
        String target = value.substring(start + 2, start + 4);
        int len1 = target.length();
        int yy = Integer.valueOf(target);
        int t = this.threshold;
        int len2 = String.valueOf(t).length();
        if (t <= yy && len1 == len2) {
            value = String.valueOf(1900 + yy) + value.substring(4, value.length());
        }
        try {
            Date date2 = formatter.parse(value);
            return date2;
        }
        catch (ParseException e) {
            if (!this.isTargetCommandConvert(context, this.targets)) {
                Object var17_20 = null;
                return var17_20;
            }
            Object[] args = ConvertUtil.createExceptionMessageArgs((UIComponent)component, (String)value);
            throw ConvertUtil.wrappedByConverterException((Converter)this, (FacesContext)context, (Object[])args, (Throwable)e);
        }
        finally {
            this.setPattern(pattern);
        }
    }

    public Date adjustDate(Date date) {
        int n = this.getCalculatedDate(date);
        if (n >= defaultCenturyStart) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            calendar.set(1, n + 100);
            date = calendar.getTime();
        }
        return date;
    }

    protected int getCalculatedDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yy");
        String yy = formatter.format(date);
        return 1900 + Integer.valueOf(yy);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return super.getAsString(context, component, value);
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.threshold, this.target};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.threshold = (Integer)values[1];
        this.target = (String)values[2];
        this.setTarget(this.target);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandConvert(FacesContext context, String[] targets) {
        return ConverterUtil.isTargetCommand(context, targets);
    }

    static {
        defaultCenturyStart = GregorianCalendar.getInstance().get(1) - 80;
    }
}

