/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class ConditionFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "condition";
    private static final String IS_PARAM_PREFIX = "is";
    private static final String ISNOT_PARAM_PREFIX = "isNot";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String id = elementNode.getId();
        if (StringUtil.isEmpty((String)id)) {
            return false;
        }
        String tagName = elementNode.getTagName();
        boolean isId = StringUtil.startsWithIgnoreCase((String)id, (String)IS_PARAM_PREFIX) && !StringUtil.startsWithIgnoreCase((String)id, (String)ISNOT_PARAM_PREFIX);
        boolean isNotId = StringUtil.startsWithIgnoreCase((String)id, (String)ISNOT_PARAM_PREFIX);
        if (!isId && !isNotId) {
            return false;
        }
        String s = null;
        s = isId ? id.substring(IS_PARAM_PREFIX.length()) : id.substring(ISNOT_PARAM_PREFIX.length());
        boolean hasProperty = pageDesc.hasProperty(StringUtil.decapitalize((String)s));
        return (ConditionFactory.isDiv(tagName) || ConditionFactory.isSpan(tagName)) && hasProperty;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String id = elementNode.getId();
        String pageName = pageDesc.getPageName();
        String s = null;
        String expression = null;
        if (StringUtil.startsWithIgnoreCase((String)id, (String)IS_PARAM_PREFIX) && !StringUtil.startsWithIgnoreCase((String)id, (String)ISNOT_PARAM_PREFIX)) {
            s = id.substring(IS_PARAM_PREFIX.length());
            s = StringUtil.decapitalize((String)s);
            s = s + " == true";
            expression = this.getBindingExpression(pageName, s);
        } else if (StringUtil.startsWithIgnoreCase((String)id, (String)ISNOT_PARAM_PREFIX)) {
            s = id.substring(ISNOT_PARAM_PREFIX.length());
            s = StringUtil.decapitalize((String)s);
            s = s + " == false";
            expression = this.getBindingExpression(pageName, s);
        }
        properties.put("rendered", expression);
        String tagName = elementNode.getTagName();
        if (tagName != null && "span".equalsIgnoreCase(tagName)) {
            properties.put("renderSpan", "true");
        }
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    private static final boolean isDiv(String tagName) {
        return "div".equalsIgnoreCase(tagName);
    }

    private static final boolean isSpan(String tagName) {
        return "span".equalsIgnoreCase(tagName);
    }
}

