/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class InputRadioFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "inputRadio";

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (pageDesc == null) {
            return false;
        }
        if (!"span".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (!pageDesc.hasProperty(id)) {
            return false;
        }
        int radioNodeCount = 0;
        for (int i = 0; i < elementNode.getChildSize(); ++i) {
            String name;
            ElementNode node;
            String childTagName;
            HtmlNode child = elementNode.getChild(i);
            if (!(child instanceof ElementNode) || !"input".equalsIgnoreCase(childTagName = (node = (ElementNode)child).getTagName()) || !"radio".equalsIgnoreCase(node.getProperty("type")) || (name = node.getProperty("name")) == null || !name.equals(id)) continue;
            ++radioNodeCount;
        }
        return radioNodeCount != 0;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc != null) {
            properties.put("value", this.getBindingExpression(pageDesc.getPageName(), elementNode.getId()));
        }
    }
}

