/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementProcessor;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.html.processor.ElementProcessorImpl;

public class OutputLinkFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "outputLink";
    private static final String PARAM_TAG_NAME = "param";
    private static final String FIXED_PREFIX = "fixed_";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"a".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (PortletUtil.isPortlet((FacesContext)FacesContext.getCurrentInstance())) {
            return id.startsWith("go") || id.startsWith("jump");
        }
        return id.startsWith("go");
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        this.renameProperty(properties, "href", "value");
    }

    protected void customizeProcessor(ElementProcessor processor, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProcessor(processor, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String value = processor.getProperty("value");
        if (value == null) {
            return;
        }
        int index = value.lastIndexOf(63);
        if (index < 0) {
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        String queryString = value.substring(index + 1);
        String[] entries = StringUtil.split((String)queryString, (String)"&");
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            if (entry.startsWith(FIXED_PREFIX)) {
                buf.append(entry.substring(FIXED_PREFIX.length())).append("&");
                continue;
            }
            String[] elems = StringUtil.split((String)entry, (String)" =");
            if (pageDesc.hasProperty(elems[0])) {
                this.appendParam(processor, pageDesc, elems[0]);
                continue;
            }
            buf.append(entry).append("&");
        }
        value = value.substring(0, index);
        if (buf.length() != 0) {
            buf.setLength(buf.length() - 1);
            value = value + "?" + buf.toString();
        }
        processor.setProperty("value", value);
    }

    protected void appendParam(ElementProcessor processor, PageDesc pageDesc, String name) {
        Class tagClass = this.getTagClass("http://java.sun.com/jsf/core", PARAM_TAG_NAME);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", name);
        props.put("value", this.getBindingExpression(pageDesc.getPageName(), name));
        ElementProcessorImpl paramProcessor = new ElementProcessorImpl(tagClass, props);
        processor.addElement(paramProcessor);
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }
}

