/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.util.LayoutUtil;

public class SelectOneRadioFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "selectOneRadio";

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"span".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        String items = id + "Items";
        if (!pageDesc.hasItemsProperty(items)) {
            return false;
        }
        int elementNodeCount = 0;
        for (int i = 0; i < elementNode.getChildSize(); ++i) {
            HtmlNode child = elementNode.getChild(i);
            if (!(child instanceof ElementNode)) continue;
            ++elementNodeCount;
            ElementNode node = (ElementNode)child;
            String childTagName = node.getTagName();
            if (!"input".equalsIgnoreCase(childTagName) || !"radio".equalsIgnoreCase(node.getProperty("type"))) {
                return false;
            }
            String name = node.getProperty("name");
            if (name != null && name.equals(id)) continue;
            return false;
        }
        return elementNodeCount != 0;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        String id = elementNode.getId();
        String items = id + "Items";
        properties.put("value", this.getBindingExpression(pageName, id));
        properties.put("items", this.getBindingExpression(pageName, items));
        if (properties.containsKey("style")) {
            LayoutUtil.styleToLayout(properties);
        }
    }

    public boolean isLeaf() {
        return true;
    }
}

