/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.internal.scope.SubApplicationScope;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.MethodBindingUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.NullErrorPageManagerImpl;
import org.seasar.teeda.extension.exception.IllegalPageTransitionException;
import org.seasar.teeda.extension.helper.PathHelper;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ActionDescCache;
import org.seasar.teeda.extension.html.HtmlComponentInvoker;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;

public class HtmlComponentInvokerImpl
implements HtmlComponentInvoker {
    private static Logger logger = Logger.getLogger((Class)HtmlComponentInvokerImpl.class);
    private NamingConvention namingConvention;
    private PathHelper pathHelper;
    public static final String errorManager_BINDING = "bindingType=may";
    private ErrorPageManager errorPageManager = new NullErrorPageManagerImpl();
    private PageDescCache pageDescCache;
    private ActionDescCache actionDescCache;

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public PathHelper getPathHelper() {
        return this.pathHelper;
    }

    public void setPathHelper(PathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this.errorPageManager = errorPageManager;
    }

    public ActionDescCache getActionDescCache() {
        return this.actionDescCache;
    }

    public void setActionDescCache(ActionDescCache actionDescCache) {
        this.actionDescCache = actionDescCache;
    }

    public PageDescCache getPageDescCache() {
        return this.pageDescCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public String invokeInitialize(FacesContext context, String componentName) {
        return this.invoke(context, componentName, "initialize");
    }

    public String invokePrerender(FacesContext context, String componentName) {
        return this.invoke(context, componentName, "prerender");
    }

    public String invoke(FacesContext context, String componentName, String methodName) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"methodName", (Object)methodName);
        if ("initialize".equals(methodName)) {
            this.setInitialized(context, true);
        }
        if (componentName == null) {
            return null;
        }
        String next = null;
        String fromAction = MethodBindingUtil.getFromAction((String)componentName, (String)methodName);
        String pageSuffix = this.namingConvention.getPageSuffix();
        if (!DIContainerUtil.hasComponent((Object)componentName)) {
            return null;
        }
        Object component = DIContainerUtil.getComponent((Object)componentName);
        Class<?> componentClass = component.getClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        Object ret = null;
        try {
            ret = beanDesc.invoke(component, methodName, null);
            if ("doFinish".equals(methodName)) {
                SubApplicationScope.removeContext((FacesContext)context);
            }
            if (ret instanceof Class) {
                Class retClass = (Class)ret;
                if (retClass != null && !retClass.getName().endsWith(pageSuffix)) {
                    throw new IllegalPageTransitionException(retClass);
                }
                next = this.getNextPageTransition(retClass);
            } else {
                next = (String)ret;
            }
            NavigationHandlerUtil.handleNavigation((FacesContext)context, (String)fromAction, (String)next);
        }
        catch (Exception e) {
            try {
                ExternalContext extContext = context.getExternalContext();
                if (!this.errorPageManager.handleException((Throwable)e, context, extContext)) {
                    throw new EvaluationException((Throwable)e);
                }
                context.responseComplete();
            }
            catch (IOException ioe) {
                logger.log((Throwable)ioe);
                throw new EvaluationException((Throwable)e);
            }
        }
        return next;
    }

    public boolean isInitialized(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean initialized = (Boolean)requestMap.get(this.getClass().getName());
        if (initialized == null) {
            return false;
        }
        return initialized;
    }

    protected void setInitialized(FacesContext context, boolean initialized) {
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(this.getClass().getName(), initialized);
    }

    protected String getNextPageTransition(Class toPageClass) {
        String path = this.pathHelper.fromPageClassToViewRootRelativePath(toPageClass);
        path = path.substring(1);
        path = StringUtil.trimSuffix((String)path, (String)this.namingConvention.getViewExtension());
        return path.replaceAll("/", "_");
    }

    public String getComponentName(String path, String methodName) {
        ActionDesc actionDesc;
        String componentName = null;
        PageDesc pageDesc = this.pageDescCache.getPageDesc(path);
        if (pageDesc != null && pageDesc.hasMethod(methodName)) {
            componentName = pageDesc.getPageName();
        }
        if (componentName == null && (actionDesc = this.actionDescCache.getActionDesc(path)) != null && actionDesc.hasMethod(methodName)) {
            componentName = actionDesc.getActionName();
        }
        return componentName;
    }
}

