/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SAXRuntimeException;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.HtmlParser;
import org.seasar.teeda.extension.html.impl.HtmlNodeHandler;
import org.seasar.teeda.extension.html.impl.TeedaSAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlParserImpl
implements HtmlParser {
    private Map dtdPaths = new HashMap();
    private String encoding = "UTF-8";

    public HtmlNode parse(InputStream is, String viewId) {
        try {
            TeedaSAXParser parser = new TeedaSAXParser();
            HtmlNodeHandler handler = this.createHtmlNodeHandler();
            InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)this.getEncoding());
            parser.setContentHandler(handler);
            parser.setEntityResolver(handler);
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId(viewId);
            parser.parse(inputSource);
            return handler.getRoot();
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected HtmlNodeHandler createHtmlNodeHandler() {
        HtmlNodeHandler htmlNodeHandler = (HtmlNodeHandler)DIContainerUtil.getComponent((Object)HtmlNodeHandler.class);
        Iterator itr = this.dtdPaths.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String publicId = (String)entry.getKey();
            String dtdPath = (String)entry.getValue();
            htmlNodeHandler.registerDtdPath(publicId, dtdPath);
        }
        return htmlNodeHandler;
    }

    public void registerDtdPath(String publicId, String dtdPath) {
        this.dtdPaths.put(publicId, dtdPath);
    }

    public void clearDtdPath() {
        this.dtdPaths.clear();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

