/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.seasar.teeda.extension.html.impl.TeedaXMLAttributesImpl;

public class TeedaXMLDocumentFilterImpl
implements XMLDocumentFilter {
    protected int inEntity;
    private XMLDocumentHandler orgHandler;
    private String xmlEncoding = "UTF-8";
    private static final String SEP = System.getProperty("line.separator");
    private static final String BEGIN_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.orgHandler.startElement(element, (XMLAttributes)new TeedaXMLAttributesImpl((XMLAttributesImpl)attributes), augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.inEntity == 0) {
            this.orgHandler.characters(text, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        StringBuffer buf = new StringBuffer(text.length + 7);
        buf.append(BEGIN_COMMENT).append(text.ch, text.offset, text.length).append(END_COMMENT);
        String comment = new String(buf);
        this.orgHandler.characters(new XMLString(comment.toCharArray(), 0, comment.length()), augs);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        StringBuffer buf = new StringBuffer(128);
        buf.append("<!DOCTYPE ").append(rootElement);
        if (publicId != null) {
            buf.append(" PUBLIC \"").append(publicId).append("\"");
        }
        if (systemId != null) {
            if (publicId == null) {
                buf.append(" SYSTEM");
            }
            buf.append(" \"").append(systemId).append("\"");
        }
        buf.append(">");
        buf.append(SEP);
        String docTypeDecl = new String(buf);
        this.orgHandler.characters(new XMLString(docTypeDecl.toCharArray(), 0, docTypeDecl.length()), augs);
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.orgHandler.emptyElement(element, (XMLAttributes)new TeedaXMLAttributesImpl((XMLAttributesImpl)attributes), augs);
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.orgHandler.endCDATA(augs);
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.orgHandler.endDocument(augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.orgHandler.endElement(element, augs);
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        --this.inEntity;
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.orgHandler.ignorableWhitespace(text, augs);
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        this.orgHandler.processingInstruction(target, data, augs);
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.orgHandler.startCDATA(augs);
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.orgHandler.startDocument(locator, this.xmlEncoding, namespaceContext, augs);
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        String entityRef = new String(new StringBuffer(name.length() + 2).append("&").append(name).append(";"));
        this.orgHandler.characters(new XMLString(entityRef.toCharArray(), 0, entityRef.length()), augs);
        ++this.inEntity;
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        this.orgHandler.textDecl(version, this.xmlEncoding, augs);
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        StringBuffer buf = new StringBuffer(128);
        if (version != null) {
            buf.append("<?xml version=\"").append(version).append("\"");
        }
        if (encoding != null) {
            buf.append(" encoding=\"").append(encoding).append("\"");
            this.xmlEncoding = encoding;
        }
        if (standalone != null) {
            buf.append(" standalone=\"").append(standalone).append("\"");
        }
        buf.append("?>").append(SEP);
        String xml = buf.toString();
        this.orgHandler.characters(new XMLString(xml.toCharArray(), 0, xml.length()), augs);
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.orgHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.orgHandler = handler;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.orgHandler.getDocumentSource();
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.orgHandler.setDocumentSource(source);
    }
}

