/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.extension.component.AbstractInclude;
import org.seasar.teeda.extension.helper.PathHelper;
import org.seasar.teeda.extension.html.HtmlComponentInvoker;
import org.seasar.teeda.extension.render.IncludedBody;

public abstract class AbstractIncludeRenderer
extends AbstractRenderer {
    private ViewHandler viewHandler;
    private PathHelper pathHelper;
    private HtmlComponentInvoker htmlComponentInvoker;

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public PathHelper getPathHelper() {
        return this.pathHelper;
    }

    public void setPathHelper(PathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public HtmlComponentInvoker getHtmlComponentInvoker() {
        return this.htmlComponentInvoker;
    }

    public void setHtmlComponentInvoker(HtmlComponentInvoker htmlComponentInvoker) {
        this.htmlComponentInvoker = htmlComponentInvoker;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        this.include(context, (AbstractInclude)component);
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            child.processDecodes(context);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        component.getChildren().clear();
    }

    protected void include(FacesContext context, AbstractInclude component) {
        IncludedBody includedBody = this.getIncludedBody(context, component);
        if (includedBody == null) {
            return;
        }
        component.getChildren().addAll(includedBody.getComponentList());
        component.setIncludedViewId(includedBody.getViewId());
    }

    protected abstract IncludedBody getIncludedBody(FacesContext var1, AbstractInclude var2);

    protected void invoke(FacesContext context, String includedViewId) {
        String componentName;
        if (this.htmlComponentInvoker.isInitialized(context) && (componentName = this.htmlComponentInvoker.getComponentName(includedViewId, "initialize")) != null) {
            this.htmlComponentInvoker.invokeInitialize(context, componentName);
        }
        if (context.getResponseComplete()) {
            return;
        }
        componentName = this.htmlComponentInvoker.getComponentName(includedViewId, "prerender");
        if (componentName != null) {
            this.htmlComponentInvoker.invokePrerender(context, componentName);
        }
        if (context.getResponseComplete()) {
            return;
        }
    }
}

