/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.internal.UIComponentUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.component.AbstractInclude;
import org.seasar.teeda.extension.component.TInclude;
import org.seasar.teeda.extension.component.UIBody;
import org.seasar.teeda.extension.render.AbstractIncludeRenderer;
import org.seasar.teeda.extension.render.IncludedBody;

public class TIncludeRenderer
extends AbstractIncludeRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Include";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Include";
    private static final Logger logger = Logger.getLogger((Class)TIncludeRenderer.class);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        AbstractInclude inc = (AbstractInclude)component;
        if (!inc.isIncluded()) {
            this.include(context, inc);
        }
        if (!inc.isIncluded()) {
            return;
        }
        this.invoke(context, inc.getIncludedViewId());
    }

    protected IncludedBody getIncludedBody(FacesContext context, AbstractInclude component) {
        String src = ((TInclude)component).getSrc();
        if (StringUtil.isEmpty((String)src)) {
            return null;
        }
        String srcViewId = this.getPathHelper().fromViewRootRelativePathToViewId(src);
        UIViewRoot viewRoot = this.getViewHandler().restoreView(context, srcViewId);
        if (viewRoot == null) {
            viewRoot = this.getViewHandler().createView(context, srcViewId);
        }
        if (viewRoot == null) {
            return null;
        }
        UIComponent body = UIComponentUtil.findDescendant((UIComponent)viewRoot, (Class)UIBody.class);
        if (body == null) {
            logger.log("WTDA0202", new Object[]{viewRoot.getViewId()});
        }
        return new IncludedBody(viewRoot.getViewId(), body.getChildren());
    }
}

