/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.UIComponentUtil;
import javax.servlet.ServletContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.PostbackUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ServletContextUtil;
import org.seasar.teeda.extension.component.TViewRoot;
import org.seasar.teeda.extension.component.UITitle;
import org.seasar.teeda.extension.component.html.THtmlHead;
import org.seasar.teeda.extension.helper.PathHelper;
import org.seasar.teeda.extension.html.HtmlComponentInvoker;
import org.seasar.teeda.extension.html.HtmlDescCache;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.render.IncludedBody;
import org.seasar.teeda.extension.render.Invokable;
import org.seasar.teeda.extension.render.Layoutable;

public class TViewRootRenderer
extends AbstractRenderer
implements Invokable,
Layoutable {
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.ViewRoot";
    public static final String LIST_KEY = TViewRootRenderer.class.getName();
    public static final String POP_INDEX_KEY = LIST_KEY + ".INDEX";
    private static final Logger logger = Logger.getLogger((Class)TViewRootRenderer.class);
    private ViewHandler viewHandler;
    private HtmlComponentInvoker htmlComponentInvoker;
    private ServletContext servletContext;
    private HtmlDescCache htmlDescCache;
    private PageDescCache pageDescCache;
    private PathHelper pathHelper;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$UIBody;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$UITitle;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$html$THtmlStyle;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$html$THtmlScript;

    public static IncludedBody popIncludedBody(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        List list = (List)requestMap.get(LIST_KEY);
        if (list == null) {
            return null;
        }
        Integer popIndex = (Integer)requestMap.get(POP_INDEX_KEY);
        if (popIndex == null) {
            return null;
        }
        int index = popIndex;
        IncludedBody body = (IncludedBody)list.get(index);
        requestMap.put(POP_INDEX_KEY, new Integer(index - 1));
        return body;
    }

    protected static void pushIncludedBody(FacesContext context, IncludedBody includedBody) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList<IncludedBody> list = (ArrayList<IncludedBody>)requestMap.get(LIST_KEY);
        if (list == null) {
            list = new ArrayList<IncludedBody>();
            requestMap.put(LIST_KEY, list);
        }
        requestMap.put(POP_INDEX_KEY, new Integer(list.size()));
        list.add(includedBody);
    }

    protected static List getIncludedBodies(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        return (List)requestMap.get(LIST_KEY);
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        this.layout(context, (TViewRoot)component);
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            child.processDecodes(context);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        TViewRoot viewRoot = (TViewRoot)component;
        if (viewRoot.getRootViewId() == null) {
            this.layout(context, viewRoot);
        }
        this.invokeAll(context);
        this.invoke(context, viewRoot.getRootViewId());
        if (!context.getResponseComplete()) {
            RendererUtil.renderChildren((FacesContext)context, (UIComponent)component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    public void layout(FacesContext context, TViewRoot component) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)((Object)component));
        TViewRoot child = component;
        TViewRoot parent = this.getParentViewRoot(context, child);
        UIComponent title = null;
        List styleList = new ArrayList();
        List scriptList = new ArrayList();
        while (parent != null) {
            UIComponent head;
            UIComponent body = UIComponentUtil.findDescendant((UIComponent)child, (Class)(class$org$seasar$teeda$extension$component$UIBody == null ? TViewRootRenderer.class$("org.seasar.teeda.extension.component.UIBody") : class$org$seasar$teeda$extension$component$UIBody));
            if (body == null) {
                logger.log("WTDA0202", new Object[]{child.getViewId()});
            }
            if ((head = UIComponentUtil.findDescendant((UIComponent)component, (Class)(class$org$seasar$teeda$extension$component$html$THtmlHead == null ? TViewRootRenderer.class$("org.seasar.teeda.extension.component.html.THtmlHead") : class$org$seasar$teeda$extension$component$html$THtmlHead))) != null) {
                title = UIComponentUtil.findDescendant((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$UITitle == null ? TViewRootRenderer.class$("org.seasar.teeda.extension.component.UITitle") : class$org$seasar$teeda$extension$component$UITitle));
                styleList = UIComponentUtil.collectDescendants((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$html$THtmlStyle == null ? TViewRootRenderer.class$("org.seasar.teeda.extension.component.html.THtmlStyle") : class$org$seasar$teeda$extension$component$html$THtmlStyle));
                scriptList = UIComponentUtil.collectDescendants((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$html$THtmlScript == null ? TViewRootRenderer.class$("org.seasar.teeda.extension.component.html.THtmlScript") : class$org$seasar$teeda$extension$component$html$THtmlScript));
            }
            TViewRootRenderer.pushIncludedBody(context, new IncludedBody(child.getViewId(), body.getChildren()));
            child = parent;
            parent = this.getParentViewRoot(context, child);
        }
        if (child != component) {
            component.setRootViewId(child.getViewId());
            component.getChildren().clear();
            component.getChildren().addAll(child.getChildren());
            UIComponent head = UIComponentUtil.findDescendant((UIComponent)component, (Class)THtmlHead.class);
            if (styleList.size() > 0) {
                head.getChildren().addAll(styleList);
            }
            if (scriptList.size() > 0) {
                head.getChildren().addAll(scriptList);
            }
            if (title != null) {
                boolean foundTitle = this.replaceComponent(head, title);
            }
        } else {
            component.setRootViewId(component.getViewId());
        }
    }

    protected boolean replaceComponent(UIComponent root, UIComponent titleCandidate) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            boolean b = this.replaceComponent(child, titleCandidate);
            if (b) {
                return true;
            }
            if (!(child instanceof UITitle)) continue;
            root.getChildren().remove(i);
            root.getChildren().add(i, titleCandidate);
        }
        return false;
    }

    protected TViewRoot getParentViewRoot(FacesContext context, TViewRoot component) {
        UIViewRoot viewRoot;
        String parentViewId = this.getParentViewId(context, component);
        if (parentViewId == null) {
            return null;
        }
        if (HotdeployUtil.isHotdeploy() || this.htmlDescCache.getHtmlDesc(parentViewId) == null) {
            InputStream is = ServletContextUtil.getResourceAsStream((ServletContext)this.servletContext, (String)parentViewId);
            if (is != null) {
                InputStreamUtil.close((InputStream)is);
            } else {
                return null;
            }
        }
        if ((viewRoot = this.viewHandler.restoreView(context, parentViewId)) == null) {
            viewRoot = this.viewHandler.createView(context, parentViewId);
        }
        return (TViewRoot)viewRoot;
    }

    protected String getParentViewId(FacesContext context, TViewRoot component) {
        Object page;
        BeanDesc beanDesc;
        PropertyDesc propDesc;
        PageDesc pageDesc;
        String defaultSuffix = FacesConfigOptions.getDefaultSuffix();
        if (defaultSuffix.indexOf(".jsp") >= 0) {
            return null;
        }
        String parentPath = FacesConfigOptions.getDefaultLayoutPath();
        UIViewRoot viewRoot = context.getViewRoot();
        if (component != viewRoot || viewRoot.getViewId().indexOf("/layout/") >= 0) {
            parentPath = null;
        }
        if ((pageDesc = this.pageDescCache.getPageDesc(component.getViewId())) != null && pageDesc.hasProperty("layout") && (propDesc = (beanDesc = BeanDescFactory.getBeanDesc((page = DIContainerUtil.getComponent((Object)pageDesc.getPageName())).getClass())).getPropertyDesc("layout")).hasReadMethod()) {
            parentPath = (String)propDesc.getValue(page);
        }
        if (parentPath == null) {
            return null;
        }
        return this.pathHelper.fromViewRootRelativePathToViewId(parentPath);
    }

    public void invokeAll(FacesContext context) {
        List bodies = TViewRootRenderer.getIncludedBodies(context);
        if (bodies == null) {
            return;
        }
        for (int i = 0; i < bodies.size(); ++i) {
            IncludedBody body = (IncludedBody)bodies.get(i);
            this.invoke(context, body.getViewId());
        }
    }

    public void invoke(FacesContext context, String viewId) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (!PostbackUtil.isPostback((Map)requestMap)) {
            this.invoke(context, viewId, "initialize");
        }
        if (context.getResponseComplete()) {
            return;
        }
        this.invoke(context, viewId, "prerender");
    }

    protected String invoke(FacesContext context, String path, String methodName) {
        String componentName = this.htmlComponentInvoker.getComponentName(path, methodName);
        return this.htmlComponentInvoker.invoke(context, componentName, methodName);
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public HtmlComponentInvoker getHtmlComponentInvoker() {
        return this.htmlComponentInvoker;
    }

    public void setHtmlComponentInvoker(HtmlComponentInvoker htmlComponentInvoker) {
        this.htmlComponentInvoker = htmlComponentInvoker;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public HtmlDescCache getHtmlDescCache() {
        return this.htmlDescCache;
    }

    public void setHtmlDescCache(HtmlDescCache htmlDescCache) {
        this.htmlDescCache = htmlDescCache;
    }

    public PageDescCache getPageDescCache() {
        return this.pageDescCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public PathHelper getPathHelper() {
        return this.pathHelper;
    }

    public void setPathHelper(PathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }
}

