/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.RenderPreparableRenderer;
import org.seasar.teeda.core.util.JavaScriptPermissionUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.html.THtmlInputText;
import org.seasar.teeda.extension.render.html.THtmlInputTextRenderer;
import org.seasar.teeda.extension.util.VirtualResource;

public abstract class AbstractInputExtendTextRenderer
extends THtmlInputTextRenderer
implements RenderPreparableRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        if (JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)context)) {
            THtmlInputText input = (THtmlInputText)component;
            this.encodeInputExtendTextEnd(context, input);
        } else {
            this.encodeHtmlInputTextEnd(context, (HtmlInputText)component);
        }
    }

    public void encodePrepare(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlHtmlInputTextPrepare(context, (THtmlInputText)component);
    }

    protected void encodeHtmlHtmlInputTextPrepare(FacesContext context, THtmlInputText htmlGrid) throws IOException {
        String path = ResourceUtil.getResourcePath((String)this.getScriptKey(), (String)"js");
        VirtualResource.addJsResource(context, path);
    }

    protected void encodeInputExtendTextEnd(FacesContext context, THtmlInputText htmlInputText) throws IOException {
        this.doEncodeEndStart(context, htmlInputText);
        this.doEncodeEndCustomize(context, htmlInputText);
        this.doEncodeEndEnd(context, htmlInputText);
    }

    protected void doEncodeEndStart(FacesContext context, THtmlInputText htmlInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)htmlInputText);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"type", (Object)"text");
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)htmlInputText, (String)this.getIdForRender(context, (UIComponent)htmlInputText));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"name", (Object)htmlInputText.getClientId(context));
        String value = this.getValue(context, (UIComponent)htmlInputText);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"value", (Object)value);
        if (htmlInputText.isDisabled()) {
            this.renderDisabledAttribute(writer);
        }
    }

    protected abstract void doEncodeEndCustomize(FacesContext var1, THtmlInputText var2) throws IOException;

    protected void doEncodeEndEnd(FacesContext context, THtmlInputText htmlInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.renderRemain(htmlInputText, writer);
        writer.endElement("input");
    }

    protected abstract String getScriptKey();

    protected String getValue(FacesContext context, UIComponent component) {
        return ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)component);
    }

    protected void renderRemain(THtmlInputText htmlInputText, ResponseWriter writer) throws IOException {
        IgnoreAttribute ignore = this.buildIgnoreComponent();
        this.renderRemainAttributes((UIComponent)htmlInputText, writer, ignore);
    }

    protected IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("id");
        ignore.addAttributeName("type");
        ignore.addAttributeName("value");
        ignore.addAttributeName("errorStyleClass");
        return ignore;
    }

    protected static String appendSemiColonIfNeed(String property) {
        if (StringUtil.isEmpty((String)property)) {
            return "";
        }
        if (property.endsWith(";")) {
            return property;
        }
        return property + ";";
    }
}

