/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.render.RenderPreparableRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlHolidayCalendar;
import org.seasar.teeda.extension.util.DateFormatSymbolsUtil;
import org.seasar.teeda.extension.util.VirtualResource;

public class THtmlHolidayCalendarRenderer
extends AbstractInputRenderer
implements RenderPreparableRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlHolidayCalendar";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlHolidayCalendar";
    private static final String JS_CSS_ENCODED = "org.seasar.teeda.extension.holidaycalendar.JAVASCRIPT_ENCODED";
    private static final String RESOURCE_ROOT = "org/seasar/teeda/extension/render/html/holidaycalendar/";
    public static final String WEEKDAYS_MESSAGE_ID = "org.seasar.teeda.extension.component.HtmlHolidayCalendar.WEEKDAYS";

    public void encodePrepare(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlHolidayCalendarPrepare(context, (THtmlHolidayCalendar)component);
    }

    protected void encodeHtmlHolidayCalendarPrepare(FacesContext context, THtmlHolidayCalendar htmlCalendar) throws IOException {
        if (context.getExternalContext().getRequestMap().containsKey(JS_CSS_ENCODED)) {
            return;
        }
        VirtualResource.addCssResource(context, "org/seasar/teeda/extension/render/html/holidaycalendar/css/theme.css");
        VirtualResource.addJsResource(context, "org/seasar/teeda/extension/render/html/holidaycalendar/js/holidaycalendar.js");
        context.getExternalContext().getRequestMap().put(JS_CSS_ENCODED, Boolean.TRUE);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Integer month;
        THtmlHolidayCalendar htmlCalendar = (THtmlHolidayCalendar)component;
        Locale currentLocale = context.getViewRoot().getLocale();
        Boolean[] value = (Boolean[])htmlCalendar.getValue();
        Calendar base = Calendar.getInstance(currentLocale);
        base.setTime(new Date());
        Integer year = htmlCalendar.getYear();
        if (year != null) {
            base.set(1, year);
        }
        if ((month = htmlCalendar.getMonth()) != null) {
            base.set(2, month);
        }
        base.set(5, 1);
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = this.getWeekDays(context, symbols);
        String[] months = DateFormatSymbolsUtil.getMonths(symbols);
        int lastDayInMonth = base.getActualMaximum(5);
        int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(base.get(7));
        int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(base.getFirstDayOfWeek());
        ResponseWriter writer = context.getResponseWriter();
        writer.write("\n");
        writer.write("\n");
        writer.startElement("table", component);
        String calendarClass = htmlCalendar.getCalendarClass();
        if (calendarClass != null) {
            writer.writeAttribute("class", (Object)calendarClass, null);
        }
        int border = htmlCalendar.getBorder();
        writer.writeAttribute("border", (Object)new Integer(border), null);
        writer.write("\n");
        writer.startElement("tr", component);
        if (htmlCalendar.getMonthYearRowClass() != null) {
            writer.writeAttribute("class", (Object)htmlCalendar.getMonthYearRowClass(), null);
        }
        this.writeMonthYearHeader(context, writer, htmlCalendar, months[base.get(2)], String.valueOf(base.get(1)));
        writer.endElement("tr");
        writer.write("\n");
        writer.startElement("tr", component);
        if (htmlCalendar.getWeekRowClass() != null) {
            writer.writeAttribute("class", (Object)htmlCalendar.getWeekRowClass(), null);
        }
        this.writeWeekDayNameHeader(context, writer, (UIInput)htmlCalendar, weekStartsAtDayIndex, weekdays);
        writer.endElement("tr");
        writer.write("\n");
        this.writeDays(context, writer, htmlCalendar, value, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, weekdays, base);
        writer.endElement("table");
    }

    protected String[] getWeekDays(FacesContext context, DateFormatSymbols symbols) {
        String[] array;
        String summary = FacesMessageUtil.getSummary((FacesContext)context, (String)WEEKDAYS_MESSAGE_ID, (Object[])new Object[0]);
        if (summary != null && (array = StringUtil.split((String)summary, (String)",")).length == 7) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = array[i].trim();
            }
            return array;
        }
        return DateFormatSymbolsUtil.getWeekdays(symbols);
    }

    protected void writeMonthYearHeader(FacesContext context, ResponseWriter writer, THtmlHolidayCalendar component, String monthName, String yearName) throws IOException {
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("colspan", (Object)new Integer(7), null);
        String header = monthName;
        if (component.isShowYear().booleanValue()) {
            header = header + " " + yearName;
        }
        writer.writeText((Object)header, null);
        writer.endElement("td");
    }

    protected void writeWeekDayNameHeader(FacesContext context, ResponseWriter writer, UIInput component, int weekStartsAtDayIndex, String[] weekdays) throws IOException {
        int i;
        for (i = weekStartsAtDayIndex; i < weekdays.length; ++i) {
            writer.startElement("td", (UIComponent)component);
            writer.writeText((Object)weekdays[i], null);
            writer.endElement("td");
        }
        for (i = 0; i < weekStartsAtDayIndex; ++i) {
            writer.startElement("td", (UIComponent)component);
            writer.writeText((Object)weekdays[i], null);
            writer.endElement("td");
        }
    }

    protected void writeDays(FacesContext context, ResponseWriter writer, THtmlHolidayCalendar component, Boolean[] value, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, String[] weekDays, Calendar base) throws IOException {
        int columnIndexCounter = this.writeFirstSpace(context, writer, component, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth);
        int trNum = columnIndexCounter == 0 ? 0 : 1;
        for (int i = 0; i < lastDayInMonth; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)component);
                ++trNum;
            }
            boolean holiday = false;
            if (value != null && value.length > i && value[i] != null) {
                holiday = value[i];
            }
            String dateName = String.valueOf(i + 1);
            base.set(5, i + 1);
            int j = base.get(7);
            String prefixDateName = dateName + "-" + weekDays[this.mapCalendarDayToCommonDay(j)];
            this.writeCell(context, writer, component, dateName, holiday, prefixDateName);
            if (++columnIndexCounter != 7) continue;
            writer.endElement("tr");
            writer.write("\n");
            columnIndexCounter = 0;
        }
        this.writeLastSpace(context, writer, component, columnIndexCounter, trNum);
    }

    protected int writeFirstSpace(FacesContext context, ResponseWriter writer, THtmlHolidayCalendar component, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth) throws IOException {
        int index;
        int n = index = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : 7 - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (index == 7) {
            index = 0;
        }
        if (index == 0) {
            return 0;
        }
        writer.startElement("tr", (UIComponent)component);
        for (int i = 0; i < index; ++i) {
            this.writeEmptyCell(context, writer, component);
        }
        return index;
    }

    protected void writeEmptyCell(FacesContext context, ResponseWriter writer, THtmlHolidayCalendar component) throws IOException {
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("style", (Object)"visibility : hidden", null);
        writer.writeText((Object)"1", "value");
        writer.endElement("td");
    }

    protected void writeLastSpace(FacesContext context, ResponseWriter writer, THtmlHolidayCalendar component, int columnIndexCounter, int trNum) throws IOException {
        int i;
        if (columnIndexCounter != 0) {
            for (i = columnIndexCounter; i < 7; ++i) {
                this.writeEmptyCell(context, writer, component);
            }
            writer.endElement("tr");
            writer.write("\n");
        }
        for (i = trNum; i < 6; ++i) {
            writer.startElement("tr", (UIComponent)component);
            for (int j = 0; j < 7; ++j) {
                this.writeEmptyCell(context, writer, component);
            }
            writer.endElement("tr");
            writer.write("\n");
        }
    }

    private void writeCell(FacesContext context, ResponseWriter writer, THtmlHolidayCalendar component, String dateName, boolean holiday, String prefixDateName) throws IOException {
        String styleClass;
        String holidayCellClass = component.getHolidayCellClass();
        String dayCellClass = component.getDayCellClass();
        writer.startElement("td", (UIComponent)component);
        String clientId = component.getClientId(context);
        String tdId = clientId + "-td" + prefixDateName;
        String hiddenId = clientId + "-hidden" + prefixDateName;
        writer.writeAttribute("id", (Object)tdId, null);
        String string = styleClass = holiday ? holidayCellClass : dayCellClass;
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        String onclick = "Teeda.THolidayCalendar.toggleCell('" + tdId + "','" + hiddenId + "','" + holidayCellClass + "','" + dayCellClass + "');";
        writer.writeAttribute("onclick", (Object)onclick, null);
        writer.writeText((Object)dateName, "value");
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)String.valueOf(holiday), null);
        writer.endElement("input");
        writer.endElement("td");
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.getDecoder().decodeMany(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        this.assertNotNull(context, component);
        return RendererUtil.getConvertedUIOutputValues((FacesContext)context, (UIOutput)((UIOutput)component), (Object)submittedValue);
    }
}

