/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.LabelUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.html.THtmlOutputText;

public class THtmlOutputTextRenderer
extends HtmlOutputTextRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlOutputText";

    public THtmlOutputTextRenderer() {
        this.addIgnoreAttributeName("key");
        this.addIgnoreAttributeName("propertiesName");
        this.addIgnoreAttributeName("defaultKey");
        this.addIgnoreAttributeName("defaultPropertiesName");
    }

    protected void encodeHtmlOutputTextEnd(FacesContext context, HtmlOutputText htmlOutputText) throws IOException {
        THtmlOutputText text = (THtmlOutputText)htmlOutputText;
        ResponseWriter writer = context.getResponseWriter();
        String id = this.getIdForRender(context, (UIComponent)htmlOutputText);
        boolean isLabel = id != null && id.endsWith(context.getExternalContext().encodeNamespace("Label"));
        boolean startSpan = false;
        boolean invisible = text.isInvisible();
        if (this.containsAttributeForRender((UIComponent)htmlOutputText, this.getIgnoreAttribute()) && !invisible) {
            writer.startElement("span", (UIComponent)htmlOutputText);
            startSpan = true;
            RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)htmlOutputText, (String)id);
            this.renderRemainAttributes((UIComponent)htmlOutputText, writer, this.getIgnoreAttribute());
        }
        String value = null;
        if (isLabel) {
            String key = text.getKey();
            String propertiesName = text.getPropertiesName();
            String defaultKey = text.getDefaultKey();
            String defaultPropertiesName = text.getDefaultPropertiesName();
            value = LabelUtil.getLabelValue((String)key, (String)propertiesName, (String)defaultKey, (String)defaultPropertiesName);
        }
        if (StringUtil.isEmpty(value)) {
            value = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)htmlOutputText);
        }
        if (htmlOutputText.isEscape()) {
            writer.writeText((Object)value, null);
        } else {
            writer.write(value);
        }
        if (startSpan) {
            writer.endElement("span");
        }
    }
}

