/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.scope.RedirectScope;
import javax.faces.internal.scope.SubApplicationScope;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.exception.AlreadyRedirectingException;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.ServletErrorPageManagerImpl;
import org.seasar.teeda.core.util.ServletExternalContextUtil;
import org.seasar.teeda.extension.html.PagePersistence;

public class TeedaExtensionErrorPageManagerImpl
extends ServletErrorPageManagerImpl {
    private static final Logger logger = Logger.getLogger((Class)TeedaExtensionErrorPageManagerImpl.class);

    public boolean handleException(Throwable exception, FacesContext context, ExternalContext extContext) throws IOException {
        String location;
        AssertionUtil.assertNotNull((String)"exception", (Object)exception);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)exception.getMessage(), exception);
        }
        if ((location = this.getLocation(exception.getClass())) == null) {
            return false;
        }
        TeedaExtensionErrorPageManagerImpl.saveException(exception, context);
        HttpServletRequest request = ServletExternalContextUtil.getRequest((ExternalContext)extContext);
        ServletExternalContextUtil.storeErrorInfoToAttribute((ServletRequest)request, (Throwable)exception);
        SubApplicationScope.removeContext((FacesContext)context);
        PagePersistence pagePersistence = this.getPagePersistence();
        pagePersistence.save(context, location);
        String actionURL = location;
        if (location != null && location.startsWith("/")) {
            actionURL = extContext.getRequestContextPath() + location;
        }
        String redirectingPath = RedirectScope.getRedirectingPath((FacesContext)context);
        if (RedirectScope.isRedirecting((FacesContext)context) && actionURL.equals(redirectingPath)) {
            throw new AlreadyRedirectingException();
        }
        NavigationHandlerUtil.redirect((FacesContext)context, (String)actionURL);
        return true;
    }

    public static void saveException(Throwable exception, FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"exception", (Object)exception);
        Map redirectScope = RedirectScope.getOrCreateContext((FacesContext)context);
        redirectScope.put("Teeda.ErrorManager.Exception", exception);
    }

    public static void restoreMessage(FacesContext context) {
        Map redirectScope = RedirectScope.getContext((FacesContext)context);
        if (redirectScope == null) {
            return;
        }
        Throwable exception = (Throwable)redirectScope.get("Teeda.ErrorManager.Exception");
        if (exception == null) {
            return;
        }
        String message = exception.getMessage();
        if (message == null) {
            message = MessageFormatter.getMessage((String)"WTDA0204", (Object[])new Object[]{exception});
        }
        FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message);
        context.addMessage(null, fm);
        context.getExternalContext().getRequestMap().put("exception", exception);
        redirectScope.remove("Teeda.ErrorManager.Exception");
    }

    protected PagePersistence getPagePersistence() {
        return (PagePersistence)DIContainerUtil.getComponentNoException((Object)PagePersistence.class);
    }
}

