/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.MessageDigestUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.RendererUtil;

public class TransactionTokenUtil {
    public static String TOKEN = null;
    public static final String DEFAULT_TOKEN = TransactionTokenUtil.class.getName() + ".TOKEN";
    private static final String TOKENS = TransactionTokenUtil.class.getName() + ".TOKENS";
    private static final String DO_ONCE = "doOnce";
    private static long previous;

    protected TransactionTokenUtil() {
    }

    public static final boolean isDoOnce(String id) {
        if (id == null) {
            return false;
        }
        return id.startsWith(DO_ONCE);
    }

    public static synchronized String getToken(Map requestMap) {
        TransactionTokenUtil.initTokenIfNeed();
        return (String)requestMap.get(TOKEN);
    }

    public static synchronized void renderTokenIfNeed(FacesContext context, UIComponent component) throws IOException {
        TransactionTokenUtil.initTokenIfNeed();
        ExternalContext extCtx = context.getExternalContext();
        Map requestMap = extCtx.getRequestMap();
        String token = (String)requestMap.get(TOKEN);
        if (!StringUtil.isEmpty((String)token)) {
            return;
        }
        token = TransactionTokenUtil.generate(context);
        requestMap.put(TOKEN, token);
        RendererUtil.renderHidden((UIComponent)component, (ResponseWriter)context.getResponseWriter(), (String)TOKEN, (Object)token);
    }

    protected static String generate(FacesContext context) {
        ExternalContext extCtx = context.getExternalContext();
        Object session = extCtx.getSession(true);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(session.getClass());
        PropertyDesc pd = beanDesc.getPropertyDesc("id");
        String id = (String)pd.getValue(session);
        String token = TransactionTokenUtil.generate(id);
        Map sessionMap = extCtx.getSessionMap();
        HashSet<String> tokens = TransactionTokenUtil.getTokens(sessionMap);
        if (tokens == null) {
            tokens = new HashSet<String>();
            TransactionTokenUtil.setTokens(sessionMap, tokens);
        }
        tokens.add(token);
        return token;
    }

    protected static String generate(String sessionId) {
        byte[] idBytes = sessionId.getBytes();
        long current = System.currentTimeMillis();
        if (current <= previous) {
            current = previous + 1L;
        }
        previous = current;
        byte[] now = Long.toString(current).getBytes();
        MessageDigest md = MessageDigestUtil.getInstance((String)"MD5");
        md.update(idBytes);
        md.update(now);
        return StringUtil.toHex((byte[])md.digest());
    }

    protected static Set getTokens(Map sessionMap) {
        return (Set)sessionMap.get(TOKENS);
    }

    protected static void setTokens(Map sessionMap, Set tokens) {
        sessionMap.put(TOKENS, tokens);
    }

    protected static void removeTokens(Map sessionMap) {
        sessionMap.remove(TOKENS);
    }

    public static synchronized boolean verify(FacesContext context) {
        TransactionTokenUtil.initTokenIfNeed();
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String token = (String)paramMap.get(TOKEN);
        if (StringUtil.isEmpty((String)token)) {
            return false;
        }
        return TransactionTokenUtil.verify(context, token);
    }

    public static synchronized boolean verify(FacesContext context, String token) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        Set tokens = TransactionTokenUtil.getTokens(sessionMap);
        if (tokens == null) {
            return false;
        }
        if (tokens.contains(token)) {
            tokens.remove(token);
            if (tokens.size() == 0) {
                TransactionTokenUtil.removeTokens(sessionMap);
            }
            return true;
        }
        return false;
    }

    private static void initTokenIfNeed() {
        if (TOKEN == null) {
            String customizedTokenKey = FacesMessageUtil.getSummary((FacesContext)FacesContext.getCurrentInstance(), (String)DEFAULT_TOKEN, null);
            TOKEN = customizedTokenKey != null ? customizedTokenKey : DEFAULT_TOKEN;
        }
    }
}

