/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.util.ValidatorUtil;
import org.seasar.teeda.extension.validator.ValidationTargetSelectable;

public abstract class AbstractCompareValidator
implements Validator,
StateHolder,
ValidationTargetSelectable {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    private String target = null;
    private String[] targets;
    private String targetId = null;
    private boolean transientValue = false;
    private String messageId = null;

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.targetId, this.messageId, this.target};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.targetId = (String)values[0];
        this.messageId = (String)values[1];
        this.target = (String)values[2];
        this.setTarget(this.target);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        if (!this.isTargetCommandValidation(context, this.targets)) {
            return;
        }
        UIComponent targetComponent = this.getTargetComponent(component);
        Object targetValue = ValueHolderUtil.getValue((UIComponent)targetComponent);
        this.doValidate(context, component, value, targetComponent, targetValue);
    }

    public boolean isTargetCommandValidation(FacesContext context, String[] targets) {
        return ValidatorUtil.isTargetCommand(context, targets);
    }

    protected UIComponent getTargetComponent(UIComponent component) {
        if (this.targetId == null) {
            throw new EmptyRuntimeException("targetId");
        }
        UIComponent targetComponent = component.findComponent(this.targetId);
        if (targetComponent == null) {
            throw new EmptyRuntimeException(this.targetId);
        }
        return targetComponent;
    }

    protected abstract void doValidate(FacesContext var1, UIComponent var2, Object var3, UIComponent var4, Object var5) throws ValidatorException;

    public String[] getTargets() {
        return this.targets;
    }
}

