/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import java.io.UnsupportedEncodingException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.exception.ExtendValidatorException;
import org.seasar.teeda.extension.util.ValidatorUtil;
import org.seasar.teeda.extension.validator.ValidationTargetSelectable;

public class TByteLengthValidator
extends LengthValidator
implements ValidationTargetSelectable {
    public static final String VALIDATOR_ID = "teeda.extension.ByteLength";
    public static final String MAXIMUM_MESSAGE_ID = "org.seasar.teeda.extension.validator.TByteLengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "org.seasar.teeda.extension.validator.TByteLengthValidator.MINIMUM";
    public static final String ENCODE_MESSAGE_ID = "org.seasar.teeda.extension.validator.TByteLengthValidator.ENCODE";
    private String charSet = null;
    private String target;
    private String[] targets;
    private String minimumMessageId;
    private String maximumMessageId;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (!this.isTargetCommandValidation(context, this.targets)) {
            return;
        }
        try {
            super.validate(context, component, value);
        }
        catch (ValidatorException e) {
            throw new ExtendValidatorException(e.getFacesMessage(), e, new String[]{this.maximumMessageId, this.minimumMessageId});
        }
    }

    protected int getConvertedValueLength(Object value) {
        String str = null;
        str = value instanceof String ? (String)value : value.toString();
        if (StringUtil.isEmpty((String)this.charSet)) {
            return str.getBytes().length;
        }
        try {
            return TByteLengthValidator.getBytes(str, this.charSet).length;
        }
        catch (UnsupportedEncodingException e) {
            Object[] args = new Object[]{value, this.charSet};
            throw new ValidatorException(FacesMessageUtil.getMessage((FacesContext)FacesContext.getCurrentInstance(), (String)ENCODE_MESSAGE_ID, (Object[])args));
        }
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.charSet, this.target, this.maximumMessageId, this.minimumMessageId};
        return values;
    }

    public void restoreState(FacesContext context, Object obj) {
        Object[] state = (Object[])obj;
        super.restoreState(context, state[0]);
        this.charSet = (String)state[1];
        this.target = (String)state[2];
        this.setTarget(this.target);
        this.maximumMessageId = (String)state[3];
        this.minimumMessageId = (String)state[4];
    }

    private static byte[] getBytes(String value, String charSet) throws UnsupportedEncodingException {
        return value.getBytes(charSet);
    }

    public String getMaximumMessageId() {
        return !StringUtil.isEmpty((String)this.maximumMessageId) ? this.maximumMessageId : MAXIMUM_MESSAGE_ID;
    }

    public String getMinimumMessageId() {
        return !StringUtil.isEmpty((String)this.minimumMessageId) ? this.minimumMessageId : MINIMUM_MESSAGE_ID;
    }

    public void setMinimumMessageId(String minimumMessageId) {
        this.minimumMessageId = minimumMessageId;
    }

    public void setMaximumMessageId(String maximumMessageId) {
        this.maximumMessageId = maximumMessageId;
    }

    public boolean isTargetCommandValidation(FacesContext context, String[] targets) {
        return ValidatorUtil.isTargetCommand(context, targets);
    }

    public String[] getTargets() {
        return this.targets;
    }
}

