/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.mail.internet.MimeUtility;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sf.pal.common.util.StreamUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadUtil {
    private static final Log log = LogFactory.getLog((Class)DownloadUtil.class);
    public static final String OCTET_STREAM = "application/octet-stream";

    public static void setContentType(HttpServletRequest request, HttpServletResponse response, String contentType) {
        response.setContentType(contentType);
    }

    public static void setFilename(HttpServletRequest request, HttpServletResponse response, String filename) {
        if (DownloadUtil.isMSIE(request)) {
            try {
                filename = URLEncoder.encode(filename, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Unsupported Encoding.", (Throwable)e);
            }
        } else {
            try {
                filename = MimeUtility.encodeWord((String)filename, (String)"UTF-8", (String)"B");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Unsupported Encoding.", (Throwable)e);
            }
        }
        response.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
    }

    public static boolean isMSIE(HttpServletRequest request) {
        String agent = request.getHeader("user-agent");
        if (log.isDebugEnabled()) {
            log.debug((Object)("isMSIE() - agent=" + agent));
        }
        return agent.indexOf("MSIE") > 0;
    }

    public static void writeResponse(HttpServletRequest request, HttpServletResponse response, String contentType, String filename, InputStream in) throws IOException {
        DownloadUtil.setContentType(request, response, contentType);
        DownloadUtil.setFilename(request, response, filename);
        DownloadUtil.writeResponse(request, response, in);
    }

    public static void writeResponse(HttpServletRequest request, HttpServletResponse response, InputStream in) throws IOException {
        StreamUtil.drain(in, (OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
    }

    public static String getMimeType(Object context, String filename) {
        if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            return servletContext.getMimeType(filename);
        }
        if (context instanceof PortletContext) {
            PortletContext portletContext = (PortletContext)context;
            return portletContext.getMimeType(filename);
        }
        return null;
    }
}

