/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.common.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleUtil {
    private static final String DEFAULT_DELIM = "_";

    public static Locale fallback(Locale locale1, Locale locale2) {
        if (locale1 == null && locale2 == null) {
            return null;
        }
        if (locale1 == null && locale2 != null || locale1 != null && locale2 == null) {
            return null;
        }
        if (locale1.equals(locale2)) {
            return locale1;
        }
        if (locale1.getLanguage() != null && locale1.getCountry() != null && locale1.getLanguage().equals(locale2.getLanguage()) && locale1.getCountry().equals(locale2.getCountry())) {
            return new Locale(locale1.getLanguage(), locale2.getCountry());
        }
        if (locale1.getLanguage() != null && locale1.getLanguage().equals(locale2.getLanguage())) {
            return new Locale(locale1.getLanguage());
        }
        return null;
    }

    public static String convert(Locale locale) {
        return LocaleUtil.convert(locale, DEFAULT_DELIM);
    }

    public static String convert(Locale locale, String delim) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String variant = locale.getVariant();
        StringBuffer buffer = new StringBuffer(40);
        if (language != null) {
            buffer.append(language);
        }
        buffer.append(delim);
        if (country != null) {
            buffer.append(country);
        }
        buffer.append(delim);
        if (variant != null) {
            buffer.append(variant);
        }
        return buffer.toString().trim();
    }

    public static Locale convert(String localeString) {
        return LocaleUtil.convert(localeString, DEFAULT_DELIM);
    }

    public static Locale convert(String localeString, String delim) {
        if (localeString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(localeString, DEFAULT_DELIM);
        String language = tokenizer.nextToken().trim();
        String country = null;
        String variant = null;
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken().trim();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken().trim();
        }
        if (country != null && language != null && variant != null) {
            return new Locale(language, country, variant);
        }
        if (country != null && language != null) {
            return new Locale(language, country);
        }
        if (language != null) {
            return new Locale(language, "");
        }
        return null;
    }
}

