/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesresponse.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import jp.sf.pal.facesresponse.FacesResponseConstants;
import jp.sf.pal.facesresponse.io.BufferedResponseStream;
import jp.sf.pal.facesresponse.util.FacesResponseUtil;

public class BufferedResponseStreamFactory {
    public static void init(RenderRequest request, RenderResponse response) {
        String outputEncoding = response.getCharacterEncoding();
        if (FacesResponseUtil.isMyFacesFacesContext((PortletRequest)request)) {
            PortletSession session = request.getPortletSession(true);
            FacesContext facesContext = FacesResponseUtil.getMyFacesFacesContext((PortletRequest)request);
            boolean existResonseWriter = true;
            if (facesContext == null) {
                existResonseWriter = false;
            } else if (facesContext.getResponseWriter() == null) {
                existResonseWriter = false;
            }
            Object oldBufferedResonseStream = session.getAttribute(FacesResponseConstants.BUFFERED_RESPONSE_STREAM);
            if (existResonseWriter && oldBufferedResonseStream != null) {
                ((BufferedResponseStream)oldBufferedResonseStream).recycle();
            } else {
                BufferedResponseStream bufferedResponseStream = new BufferedResponseStream(outputEncoding);
                session.setAttribute(FacesResponseConstants.BUFFERED_RESPONSE_STREAM, (Object)bufferedResponseStream);
            }
        } else {
            BufferedResponseStream bufferedResponseStream = new BufferedResponseStream(outputEncoding);
            request.setAttribute(FacesResponseConstants.BUFFERED_RESPONSE_STREAM, (Object)bufferedResponseStream);
        }
    }

    public static BufferedResponseStream getBufferedResponseStream() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new IllegalStateException("FacesContext is null.");
        }
        if (FacesResponseUtil.isMyFacesFacesContext()) {
            return (BufferedResponseStream)context.getExternalContext().getSessionMap().get(FacesResponseConstants.BUFFERED_RESPONSE_STREAM);
        }
        return (BufferedResponseStream)context.getExternalContext().getRequestMap().get(FacesResponseConstants.BUFFERED_RESPONSE_STREAM);
    }

    public static BufferedResponseStream getBufferedResponseStream(PortletRequest request) {
        if (FacesResponseUtil.isMyFacesFacesContext(request)) {
            return (BufferedResponseStream)request.getPortletSession().getAttribute(FacesResponseConstants.BUFFERED_RESPONSE_STREAM);
        }
        return (BufferedResponseStream)request.getAttribute(FacesResponseConstants.BUFFERED_RESPONSE_STREAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(RenderRequest request, RenderResponse response) throws IOException {
        BufferedResponseStream bufferedResponseStream = BufferedResponseStreamFactory.getBufferedResponseStream((PortletRequest)request);
        if (bufferedResponseStream == null) {
            throw new IllegalStateException("BufferedResponseStream is null.");
        }
        BufferedResponseStream bufferedResponseStream2 = bufferedResponseStream;
        synchronized (bufferedResponseStream2) {
            bufferedResponseStream.commit();
            if (request.getWindowState() != WindowState.MINIMIZED) {
                Reader r = bufferedResponseStream.getReader();
                PrintWriter w = response.getWriter();
                char[] bytes = new char[4096];
                try {
                    int length = r.read(bytes);
                    while (length != -1) {
                        if (length != 0) {
                            ((Writer)w).write(bytes, 0, length);
                        }
                        length = r.read(bytes);
                    }
                }
                finally {
                    bytes = null;
                }
                ((Writer)w).flush();
            }
        }
        if (!FacesResponseUtil.isMyFacesFacesContext((PortletRequest)request)) {
            request.removeAttribute(FacesResponseConstants.BUFFERED_RESPONSE_STREAM);
        }
    }
}

