/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumType
implements ValueType {
    private final Class<? extends Enum> enumClass;

    public EnumType(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.toEnum(resultSet.getString(index));
    }

    protected Enum toEnum(String name) {
        if (name == null) {
            return null;
        }
        return Enum.valueOf(this.enumClass, name);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.toEnum(resultSet.getString(columnName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 12);
        } else {
            ps.setString(index, ((Enum)Enum.class.cast(value)).name());
        }
    }
}

