/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.destroymethod;

import java.lang.reflect.Method;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.IllegalDestroyMethodAnnotationRuntimeException;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.DestroyMethodDefBuilder;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;

public class S2DestroyMethodDefBuilder
implements DestroyMethodDefBuilder {
    public void appendDestroyMethodDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        for (Method method : componentClass.getMethods()) {
            DestroyMethod destroyMethod = method.getAnnotation(DestroyMethod.class);
            if (destroyMethod == null) continue;
            if (method.getParameterTypes().length != 0) {
                throw new IllegalDestroyMethodAnnotationRuntimeException(componentClass, method.getName());
            }
            if (!annotationHandler.isDestroyMethodRegisterable(componentDef, method.getName())) continue;
            componentDef.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl(method));
        }
    }
}

