/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.tx;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.ejb.tx.AbstractEJB3TxInterceptor;

public class EJB3RequiredInterceptor
extends AbstractEJB3TxInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean began = this.beginIfNecessary();
        try {
            Object result = invocation.proceed();
            if (began) {
                this.end();
            }
            return result;
        }
        catch (Throwable t) {
            if (began) {
                if (EJB3RequiredInterceptor.isRollingBack(t)) {
                    this.rollback();
                } else {
                    this.end();
                }
            }
            throw t;
        }
    }

    protected boolean beginIfNecessary() throws SystemException, NotSupportedException {
        if (this.hasTransaction()) {
            return false;
        }
        this.begin();
        return true;
    }
}

