/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.env.Env;
import org.seasar.framework.jpa.EntityManagerProvider;
import org.seasar.framework.jpa.PersistenceUnitContext;
import org.seasar.framework.jpa.PersistenceUnitManager;
import org.seasar.framework.jpa.PersistenceUnitManagerLocater;
import org.seasar.framework.jpa.PersistenceUnitProvider;
import org.seasar.framework.jpa.exception.PersistenceUnitNodFoundException;
import org.seasar.framework.jpa.impl.PersistenceUnitContextImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class PersistenceUnitManagerImpl
implements PersistenceUnitManager {
    protected static final ContextMap staticContextMap = new ContextMap();
    protected ContextMap contextMap;
    protected boolean useStaticContext = Env.getValue().startsWith("ut");
    protected String defaultPersistenceUnitName = "persistenceUnit";
    @Binding(bindingType=BindingType.MUST)
    protected PersistenceUnitProvider defaultUnitProvider;
    @Binding(bindingType=BindingType.MUST)
    protected EntityManagerProvider entityManagerProvider;
    @Binding(bindingType=BindingType.MAY)
    protected NamingConvention convention;

    @Binding(bindingType=BindingType.MAY)
    public void setUseStaticContext(boolean useStaticContext) {
        this.useStaticContext = useStaticContext;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDefaultPersistenceUnitName(String defaultPersistenceUnitName) {
        this.defaultPersistenceUnitName = defaultPersistenceUnitName;
    }

    @InitMethod
    public void open() {
        this.contextMap = this.useStaticContext ? staticContextMap : new ContextMap();
        PersistenceUnitManagerLocater.setInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DestroyMethod
    public void close() {
        PersistenceUnitManagerLocater.setInstance(null);
        ContextMap contextMap = this.contextMap;
        synchronized (contextMap) {
            if (!this.useStaticContext) {
                this.contextMap.close();
            }
        }
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        return this.getEntityManagerFactory(unitName, unitName);
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String unitName, PersistenceUnitProvider provider) {
        return this.getEntityManagerFactory(unitName, unitName, provider);
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String abstractUnitName, String concreteUnitName) {
        return this.getEntityManagerFactory(abstractUnitName, concreteUnitName, this.defaultUnitProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManagerFactory getEntityManagerFactory(String abstractUnitName, String concreteUnitName, PersistenceUnitProvider provider) {
        ContextMap contextMap = this.contextMap;
        synchronized (contextMap) {
            EntityManagerFactory emf = this.contextMap.getEntityManagerFactory(concreteUnitName);
            if (emf != null) {
                return emf;
            }
            if (provider == null) {
                throw new PersistenceUnitNodFoundException(concreteUnitName);
            }
            return this.createEntityManagerFactory(abstractUnitName, concreteUnitName, provider);
        }
    }

    protected EntityManagerFactory createEntityManagerFactory(String abstractUnitName, String concreteUnitName, PersistenceUnitProvider provider) {
        EntityManagerFactory emf = provider.createEntityManagerFactory(abstractUnitName, concreteUnitName);
        if (emf != null) {
            this.contextMap.addEntityManagerFactory(concreteUnitName, provider, emf);
            return emf;
        }
        throw new PersistenceUnitNodFoundException(concreteUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceUnitContext getPersistenceUnitContext(EntityManagerFactory emf) {
        ContextMap contextMap = this.contextMap;
        synchronized (contextMap) {
            return this.contextMap.getPersistenceUnitContext(emf);
        }
    }

    @Override
    public String getAbstractPersistenceUnitName(Class<?> entityClass) {
        if (this.convention == null) {
            return this.defaultPersistenceUnitName;
        }
        String entityPackageName = this.convention.getEntityPackageName();
        String path = ClassUtil.getResourcePath(entityClass);
        return this.getAbstractPersistenceUnitName(entityPackageName, path);
    }

    @Override
    public String getAbstractPersistenceUnitName(String mappingFile) {
        if (this.convention == null) {
            return this.defaultPersistenceUnitName;
        }
        String entityPackageName = this.convention.getEntityPackageName();
        if (mappingFile.lastIndexOf("/" + entityPackageName + "/") > -1) {
            return this.getAbstractPersistenceUnitName(entityPackageName, mappingFile);
        }
        String daoPackageName = this.convention.getDaoPackageName();
        return this.getAbstractPersistenceUnitName(daoPackageName, mappingFile);
    }

    @Override
    public String getConcretePersistenceUnitName(Class<?> entityClass) {
        if (this.convention == null) {
            return this.defaultPersistenceUnitName;
        }
        String entityPackageName = this.convention.getEntityPackageName();
        String path = ClassUtil.getResourcePath(entityClass);
        return this.getConcretePersistenceUnitName(entityPackageName, path);
    }

    @Override
    public String getConcretePersistenceUnitName(String mappingFile) {
        if (this.convention == null) {
            return this.defaultPersistenceUnitName;
        }
        String entityPackageName = this.convention.getEntityPackageName();
        if (mappingFile.lastIndexOf("/" + entityPackageName + "/") > -1) {
            return this.getConcretePersistenceUnitName(entityPackageName, mappingFile);
        }
        String daoPackageName = this.convention.getDaoPackageName();
        return this.getConcretePersistenceUnitName(daoPackageName, mappingFile);
    }

    @Override
    public PersistenceUnitProvider getPersistenceUnitProvider(Class<?> entityClass) {
        if (this.convention == null) {
            return this.getPersistenceUnitProvider(this.defaultPersistenceUnitName);
        }
        String packageName = this.convention.getEntityPackageName();
        String path = ClassUtil.getResourcePath(entityClass);
        String unitName = this.getConcretePersistenceUnitName(packageName, path);
        return this.getPersistenceUnitProvider(unitName);
    }

    @Override
    public PersistenceUnitProvider getPersistenceUnitProvider(String unitName) {
        return this.contextMap.getPersistenceUnitProvider(unitName);
    }

    protected String getAbstractPersistenceUnitName(String packageName, String path) {
        String prefix = this.getAbstractPersistenceUnitPrefix(packageName, path);
        if (StringUtil.isEmpty((String)prefix)) {
            return this.defaultPersistenceUnitName;
        }
        return prefix + StringUtil.capitalize((String)this.defaultPersistenceUnitName);
    }

    protected String getConcretePersistenceUnitName(String packageName, String path) {
        String prefix = this.getConcretePersistenceUnitPrefix(packageName, path);
        if (StringUtil.isEmpty((String)prefix)) {
            return this.defaultPersistenceUnitName;
        }
        return prefix + StringUtil.capitalize((String)this.defaultPersistenceUnitName);
    }

    protected String getAbstractPersistenceUnitPrefix(String packageName, String path) {
        String key = "/" + packageName + "/";
        int pos = path.lastIndexOf(key);
        if (pos < 0) {
            return null;
        }
        int pos2 = path.lastIndexOf(47);
        if (pos + key.length() - 1 == pos2) {
            return null;
        }
        return path.substring(pos + key.length(), pos2);
    }

    protected String getConcretePersistenceUnitPrefix(String packageName, String path) {
        String abstractPrefix = this.getAbstractPersistenceUnitPrefix(packageName, path);
        if (!StringUtil.isEmpty((String)abstractPrefix)) {
            return abstractPrefix;
        }
        return this.entityManagerProvider.getSelectableEntityManagerPrefix();
    }

    public static class ContextMap {
        protected final Map<String, PersistenceUnitProvider> persistenceUnitProviders = CollectionsUtil.newHashMap();
        protected final Map<String, EntityManagerFactory> entityManagerFactories = CollectionsUtil.newHashMap();
        protected final Map<EntityManagerFactory, PersistenceUnitContext> persistenceUnitContexts = CollectionsUtil.newHashMap();

        public PersistenceUnitProvider getPersistenceUnitProvider(String unitName) {
            return this.persistenceUnitProviders.get(unitName);
        }

        public EntityManagerFactory getEntityManagerFactory(String unitName) {
            return this.entityManagerFactories.get(unitName);
        }

        public void addEntityManagerFactory(String unitName, PersistenceUnitProvider persistenceUnitProvider, EntityManagerFactory emf) {
            this.persistenceUnitProviders.put(unitName, persistenceUnitProvider);
            this.entityManagerFactories.put(unitName, emf);
            this.persistenceUnitContexts.put(emf, new PersistenceUnitContextImpl());
        }

        public PersistenceUnitContext getPersistenceUnitContext(EntityManagerFactory emf) {
            return this.persistenceUnitContexts.get(emf);
        }

        public void close() {
            for (EntityManagerFactory emf : this.entityManagerFactories.values()) {
                emf.close();
            }
            this.entityManagerFactories.clear();
            this.persistenceUnitContexts.clear();
        }
    }
}

