/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.junit.Assert;
import org.junit.internal.runners.CompositeRunner;
import org.junit.internal.runners.MethodValidator;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.seasar.framework.unit.S2TestClassMethodsRunner;
import org.seasar.framework.unit.S2TestClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2Parameterized
extends S2TestClassRunner {
    public S2Parameterized(Class<?> klass) throws Exception {
        super(klass, (Runner)new RunAllParameterMethods(klass));
    }

    protected void validate(MethodValidator methodValidator) {
        methodValidator.validateStaticMethods();
        methodValidator.validateInstanceMethods();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAllParameterMethods
    extends CompositeRunner {
        private final Class<?> klass;

        public RunAllParameterMethods(Class<?> klass) throws Exception {
            super(klass.getName());
            this.klass = klass;
            int i = 0;
            for (Object each : this.getParametersList()) {
                if (each instanceof Object[]) {
                    super.add((Runner)new TestClassRunnerForParameters(klass, (Object[])Object[].class.cast(each), i++));
                    continue;
                }
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.klass.getName(), this.getParametersMethod().getName()));
            }
        }

        private Collection<?> getParametersList() throws IllegalAccessException, InvocationTargetException, Exception {
            return (Collection)Collection.class.cast(this.getParametersMethod().invoke(null, new Object[0]));
        }

        private Method getParametersMethod() throws Exception {
            for (Method each : this.klass.getMethods()) {
                Annotation[] annotations;
                if (!Modifier.isStatic(each.getModifiers())) continue;
                for (Annotation annotation : annotations = each.getAnnotations()) {
                    if (annotation.annotationType() != Parameterized.Parameters.class) continue;
                    return each;
                }
            }
            throw new Exception("No public static parameters method on class " + this.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassRunnerForParameters
    extends S2TestClassMethodsRunner {
        private final Object[] parameters;
        private final int parameterSetNumber;
        private final Constructor<?> constructor;

        private TestClassRunnerForParameters(Class<?> klass, Object[] parameters, int i) {
            super(klass);
            this.parameters = parameters;
            this.parameterSetNumber = i;
            this.constructor = this.getOnlyConstructor();
        }

        @Override
        protected Object createTest() throws Exception {
            return this.constructor.newInstance(this.parameters);
        }

        @Override
        protected String getName() {
            return String.format("[%s]", this.parameterSetNumber);
        }

        @Override
        protected String testName(Method method) {
            return String.format("%s[%s]", method.getName(), this.parameterSetNumber);
        }

        private Constructor<?> getOnlyConstructor() {
            Constructor<?>[] constructors = this.getTestClass().getConstructors();
            Assert.assertEquals((Object)1, (Object)constructors.length);
            return constructors[0];
        }
    }
}

