/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.io.File;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReader;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.unit.DataAccessor;
import org.seasar.framework.unit.TestContext;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TransactionManagerUtil;

public class DataAccessorImpl
implements DataAccessor {
    protected TestContext testContext;
    protected TransactionManager tm;
    protected EntityManager em;
    private DataSource dataSource;
    private Connection connection;
    private DatabaseMetaData dbMetaData;
    private SqlWriter sqlWriter;

    @Binding(bindingType=BindingType.MUST)
    public void setTestContext(TestContext testContext) {
        this.testContext = testContext;
    }

    @Binding(bindingType=BindingType.SHOULD)
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Binding(bindingType=BindingType.SHOULD)
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setSqlWriter(SqlWriter sqlWriter) {
        this.sqlWriter = sqlWriter;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return this.dataSource;
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = DataSourceUtil.getConnection((DataSource)this.getDataSource());
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        if (this.dbMetaData != null) {
            return this.dbMetaData;
        }
        this.dbMetaData = ConnectionUtil.getMetaData((Connection)this.getConnection());
        return this.dbMetaData;
    }

    protected SqlWriter getSqlWriter() {
        return this.sqlWriter != null ? this.sqlWriter : new SqlWriter(this.getDataSource());
    }

    public DataSet readXls(String path) {
        return this.readXls(path, true);
    }

    public DataSet readXls(String path, boolean trimString) {
        XlsReader reader = new XlsReader(this.convertPath(path), trimString);
        return reader.read();
    }

    public void writeXls(String path, DataSet dataSet) {
        File dir = ResourceUtil.getBuildDir(this.getClass());
        File file = new File(dir, this.convertPath(path));
        XlsWriter writer = new XlsWriter((OutputStream)FileOutputStreamUtil.create((File)file));
        writer.write(dataSet);
    }

    public void writeDb(DataSet dataSet) {
        this.flushIfNecessary();
        SqlWriter writer = this.getSqlWriter();
        writer.write(dataSet);
    }

    public DataSet readDb(DataSet dataSet) {
        this.flushIfNecessary();
        SqlReader reader = new SqlReader(this.getDataSource());
        reader.addDataSet(dataSet);
        return reader.read();
    }

    public DataTable readDbByTable(String table) {
        this.flushIfNecessary();
        return this.readDbByTable(table, null);
    }

    public DataTable readDbByTable(String table, String condition) {
        this.flushIfNecessary();
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setTable(table, condition);
        return reader.read();
    }

    public DataTable readDbBySql(String sql, String tableName) {
        this.flushIfNecessary();
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setSql(sql, tableName);
        return reader.read();
    }

    public void readXlsWriteDb(String path) {
        this.readXlsWriteDb(path, true);
    }

    public void readXlsWriteDb(String path, boolean trimString) {
        this.flushIfNecessary();
        this.writeDb(this.readXls(path, trimString));
    }

    public void readXlsReplaceDb(String path) {
        this.readXlsAllReplaceDb(path, true);
    }

    public void readXlsReplaceDb(String path, boolean trimString) {
        this.flushIfNecessary();
        DataSet dataSet = this.readXls(path, trimString);
        this.deleteDb(dataSet);
        this.writeDb(dataSet);
    }

    public void readXlsAllReplaceDb(String path) {
        this.readXlsAllReplaceDb(path, true);
    }

    public void readXlsAllReplaceDb(String path, boolean trimString) {
        this.flushIfNecessary();
        DataSet dataSet = this.readXls(path, trimString);
        for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
            this.deleteTable(dataSet.getTable(i).getTableName());
        }
        this.writeDb(dataSet);
    }

    public DataSet reload(DataSet dataSet) {
        this.flushIfNecessary();
        return new SqlReloadReader(this.getDataSource(), dataSet).read();
    }

    public DataTable reload(DataTable table) {
        this.flushIfNecessary();
        return new SqlReloadTableReader(this.getDataSource(), table).read();
    }

    public DataSet reloadOrReadDb(DataSet dataSet) {
        this.flushIfNecessary();
        DataSetImpl newDataSet = new DataSetImpl();
        block0: for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DataTable table = dataSet.getTable(i);
            if (!table.hasMetaData()) {
                table.setupMetaData(this.getDatabaseMetaData());
            }
            int j = 0;
            while (i < table.getColumnSize()) {
                DataColumn column = table.getColumn(j);
                if (column.isPrimaryKey()) {
                    newDataSet.addTable(this.reload(table));
                    continue block0;
                }
                ++j;
            }
            newDataSet.addTable(this.readDbByTable(table.getTableName()));
        }
        return newDataSet;
    }

    public void deleteDb(DataSet dataSet) {
        this.flushIfNecessary();
        SqlDeleteTableWriter writer = new SqlDeleteTableWriter(this.getDataSource());
        for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
            writer.write(dataSet.getTable(i));
        }
    }

    public void deleteTable(String tableName) {
        this.flushIfNecessary();
        BasicUpdateHandler handler = new BasicUpdateHandler(this.getDataSource(), "DELETE FROM " + tableName);
        handler.execute(null);
    }

    protected String convertPath(String path) {
        if (ResourceUtil.isExist((String)path)) {
            return path;
        }
        return this.testContext.getTestClassPackagePath() + "/" + path;
    }

    protected void flushIfNecessary() {
        if (this.em != null && TransactionManagerUtil.isActive((TransactionManager)this.tm)) {
            this.em.flush();
        }
    }
}

