/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.seasar.extension.dataset.DataSet;
import org.seasar.framework.aop.interceptors.MockInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.TigerAnnotationHandler;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.message.MessageResourceBundleFactory;
import org.seasar.framework.unit.ConfigFileIncluder;
import org.seasar.framework.unit.ExpectedDataReader;
import org.seasar.framework.unit.InternalTestContext;
import org.seasar.framework.unit.PreparationType;
import org.seasar.framework.unit.TestDataPreparer;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInternalTestContext
implements InternalTestContext {
    protected final TigerAnnotationHandler handler = new TigerAnnotationHandler();
    protected final List<MockInterceptor> mockInterceptors = CollectionsUtil.newArrayList();
    protected S2Container container;
    protected NamingConvention namingConvention;
    protected Class<?> testClass;
    protected Method testMethod;
    protected boolean autoIncluding = true;
    protected boolean autoPreparing = true;
    protected PreparationType preparationType = PreparationType.WRITE;
    protected boolean trimString = true;
    protected boolean ejb3Enabled = false;
    protected boolean jtaEnabled = false;
    protected boolean containerInitialized;

    @Binding(bindingType=BindingType.MUST)
    public void setContainer(S2Container container) {
        this.container = container.getRoot();
    }

    @Binding(bindingType=BindingType.MAY)
    public void setEjb3Enabled(boolean ejb3Enabled) {
        this.ejb3Enabled = ejb3Enabled;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setJtaEnabled(boolean jtaEnabled) {
        this.jtaEnabled = jtaEnabled;
    }

    @Override
    public void setAutoIncluding(boolean autoIncluding) {
        this.autoIncluding = autoIncluding;
    }

    @Override
    public void setAutoPreparing(boolean autoPreparing) {
        this.autoPreparing = autoPreparing;
    }

    @Override
    public PreparationType getPreparationType() {
        return this.preparationType;
    }

    @Override
    public void setPreparationType(PreparationType preparationType) {
        this.preparationType = preparationType;
    }

    @Override
    public void setTrimString(boolean trimString) {
        this.trimString = trimString;
    }

    @Override
    public boolean isTrimString() {
        return this.trimString;
    }

    @Override
    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    @Override
    public void setTestMethod(Method testMethod) {
        this.testMethod = testMethod;
    }

    @InitMethod
    public void init() throws Throwable {
        this.namingConvention = new NamingConventionImpl();
        this.container.register((Object)this.namingConvention);
    }

    @DestroyMethod
    public void destroy() {
        MessageResourceBundleFactory.clear();
        this.namingConvention = null;
    }

    @Override
    public void initContainer() {
        this.container.init();
        this.containerInitialized = true;
    }

    @Override
    public void destroyContainer() {
        this.container.destroy();
        this.container = null;
        this.containerInitialized = false;
    }

    @Override
    public void include() {
        if (this.autoIncluding && this.container.hasComponentDef(ConfigFileIncluder.class)) {
            ConfigFileIncluder includer = (ConfigFileIncluder)this.container.getComponent(ConfigFileIncluder.class);
            includer.include(this);
        }
    }

    @Override
    public void include(String path) {
        String convertedPath = ResourceUtil.convertPath((String)path, this.testClass);
        S2ContainerFactory.include((S2Container)this.container, (String)convertedPath);
    }

    @Override
    public void register(Class<?> componentClass, String componentName) {
        ComponentDef cd = this.handler.createComponentDef(componentClass, InstanceDefFactory.SINGLETON);
        cd.setComponentName(componentName);
        this.handler.appendDI(cd);
        this.handler.appendAspect(cd);
        this.handler.appendInterType(cd);
        this.handler.appendInitMethod(cd);
        this.handler.appendDestroyMethod(cd);
        this.container.register(cd);
    }

    @Override
    public void register(Class<?> componentClass) {
        this.register(componentClass, this.namingConvention.fromClassNameToComponentName(componentClass.getName()));
    }

    @Override
    public void register(ComponentDef componentDef) {
        this.container.register(componentDef);
    }

    @Override
    public void register(Object component, String componentName) {
        this.container.register(component, componentName);
    }

    @Override
    public void register(Object component) {
        this.container.register(component);
    }

    @Override
    public String getTestClassPackagePath() {
        return this.testClass.getName().replace('.', '/').replaceFirst("/[^/]+$", "");
    }

    @Override
    public String getTestClassShortName() {
        return ClassUtil.getShortClassName(this.testClass);
    }

    @Override
    public String getTestMethodName() {
        return this.testMethod.getName();
    }

    @Override
    public void prepareTestData() {
        if (this.autoPreparing && this.hasComponentDef(TestDataPreparer.class)) {
            TestDataPreparer preparer = this.getComponent(TestDataPreparer.class);
            preparer.prepare(this);
        }
    }

    @Override
    public DataSet getExpected() {
        ExpectedDataReader reader;
        DataSet expected;
        if (this.hasComponentDef(ExpectedDataReader.class) && (expected = (reader = this.getComponent(ExpectedDataReader.class)).read(this)) != null) {
            return expected;
        }
        return null;
    }

    @Override
    public MockInterceptor getMockInterceptor(int index) {
        return this.mockInterceptors.get(index);
    }

    @Override
    public S2Container getContainer() {
        return this.container;
    }

    @Override
    public <T> T getComponent(Class<? extends T> componentKey) {
        return componentKey.cast(this.container.getComponent(componentKey));
    }

    @Override
    public Object getComponent(Object componentKey) {
        return this.container.getComponent(componentKey);
    }

    @Override
    public boolean hasComponentDef(Object componentKey) {
        return this.container.hasComponentDef(componentKey);
    }

    @Override
    public ComponentDef getComponentDef(int index) {
        return this.container.getComponentDef(index);
    }

    @Override
    public ComponentDef getComponentDef(Object componentKey) {
        return this.container.getComponentDef(componentKey);
    }

    @Override
    public void addMockInterceptor(MockInterceptor mockInterceptor) {
        this.mockInterceptors.add(mockInterceptor);
    }

    @Override
    public int getMockInterceptorSize() {
        return this.mockInterceptors.size();
    }

    @Override
    public void addAspecDef(Object componentKey, AspectDef aspectDef) {
        if (this.containerInitialized) {
            throw new IllegalStateException();
        }
        this.container.getComponentDef(componentKey).addAspectDef(0, aspectDef);
    }

    @Override
    public boolean isEjb3Enabled() {
        return this.ejb3Enabled;
    }

    @Override
    public boolean isJtaEnabled() {
        return this.jtaEnabled;
    }
}

