/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.portletfilter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;

public class PortletFilterConfig {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$bridges$portletfilter$PortletFilterConfig == null ? (class$org$apache$portals$bridges$portletfilter$PortletFilterConfig = PortletFilterConfig.class$("org.apache.portals.bridges.portletfilter.PortletFilterConfig")) : class$org$apache$portals$bridges$portletfilter$PortletFilterConfig));
    private String PARAMETER_SEPRATOR = ":";
    private PortletFilter portletFilter = null;
    private PortletConfig portletConfig;
    private String filterName;
    private Map parameters;
    static /* synthetic */ Class class$org$apache$portals$bridges$portletfilter$PortletFilterConfig;

    public PortletFilterConfig(String filterName, PortletConfig config) throws PortletException {
        this.setPortletConfig(config);
        this.setFilterName(filterName);
        this.parseParameters();
        try {
            Object portletFilter;
            Class<?> portletFilterClass = Class.forName(filterName);
            if (portletFilterClass != null) {
                portletFilter = portletFilterClass.newInstance();
                if (!(portletFilter instanceof PortletFilter)) {
                    throw new PortletException(filterName + " is not PortletFilter class.");
                }
            } else {
                throw new PortletException(filterName + " is not found.");
            }
            this.portletFilter = (PortletFilter)portletFilter;
        }
        catch (ClassNotFoundException e) {
            throw new PortletException("ClassNotFoundException occurred.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PortletException("InstantiationException occurred.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PortletException("IllegalAccessException occurred.", (Throwable)e);
        }
        this.portletFilter.init(this);
    }

    private void parseParameters() {
        this.parameters = new HashMap();
        Enumeration e = this.getPortletConfig().getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(this.getFilterName() + this.PARAMETER_SEPRATOR)) continue;
            String newKey = key.substring(this.getFilterName().length() + this.PARAMETER_SEPRATOR.length());
            this.parameters.put(newKey, this.getPortletConfig().getInitParameter(key));
        }
    }

    public String getInitParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        if (this.parameters == null) {
            return new Enumerator(new ArrayList().iterator());
        }
        return new Enumerator(this.parameters.keySet().iterator());
    }

    public PortletFilter getPortletFilter() {
        return this.portletFilter;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void release() {
        this.portletFilter.destroy();
        this.portletConfig = null;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final class Enumerator
    implements Enumeration {
        private Iterator iterator = null;

        public Enumerator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() throws NoSuchElementException {
            return this.iterator.next();
        }
    }
}

