/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.jetspeed.profiler.ProfileLocatorProperty;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.impl.ProfileFallbackIterator;
import org.apache.jetspeed.profiler.impl.ProfileLocatorControl;
import org.apache.jetspeed.profiler.impl.ProfileLocatorPropertyImpl;
import org.apache.jetspeed.profiler.rules.RuleCriterion;

public class JetspeedProfileLocator
implements ProfileLocatorControl {
    private LinkedList elements = new LinkedList();
    private String requestPath;

    public List getElements() {
        return this.elements;
    }

    public void init(Profiler profiler, String requestPath) {
        this.requestPath = requestPath != null ? (requestPath.indexOf("/") != -1 ? requestPath : "/" + requestPath) : "/";
    }

    public Iterator iterator() {
        return new ProfileFallbackIterator(this);
    }

    public String getValue(String name) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            ProfileLocatorPropertyImpl element = (ProfileLocatorPropertyImpl)iter.next();
            String elementName = element.getName();
            if (elementName == null || !elementName.equals(name)) continue;
            return element.getValue();
        }
        return null;
    }

    public boolean isControl(String name) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            ProfileLocatorPropertyImpl element = (ProfileLocatorPropertyImpl)iter.next();
            String elementName = element.getName();
            if (elementName == null || !elementName.equals(name)) continue;
            return element.isControl();
        }
        return false;
    }

    public boolean isNavigation(String name) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            ProfileLocatorPropertyImpl element = (ProfileLocatorPropertyImpl)iter.next();
            String elementName = element.getName();
            if (elementName == null || !elementName.equals(name)) continue;
            return element.isNavigation();
        }
        return false;
    }

    public void add(RuleCriterion criterion, boolean isControl, boolean isNavigation, String value) {
        this.elements.add(new ProfileLocatorPropertyImpl(criterion, isControl, isNavigation, value));
    }

    public void add(String name, boolean isControl, boolean isNavigation, String value) {
        this.elements.add(new ProfileLocatorPropertyImpl(name, isControl, isNavigation, value));
    }

    public void add(String name, String value) {
        this.add(name, true, false, value);
    }

    public void createFromLocatorPath(String path) {
        this.elements.clear();
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            String value = tokenizer.nextToken();
            this.add(name, true, false, value);
        }
    }

    public String getLocatorPath() {
        StringBuffer key = new StringBuffer();
        ListIterator it = this.elements.listIterator();
        while (it.hasNext()) {
            ProfileLocatorPropertyImpl element = (ProfileLocatorPropertyImpl)it.next();
            key.append(element.getName());
            key.append(":");
            key.append(element.getValue());
            if (!it.hasNext()) continue;
            key.append(":");
        }
        return key.toString();
    }

    public String getLocatorPath(ProfileLocatorProperty[] properties) {
        StringBuffer key = new StringBuffer();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                if (i > 0) {
                    key.append(":");
                }
                key.append(properties[i].getName());
                key.append(":");
                key.append(properties[i].getValue());
            }
        }
        return key.toString();
    }

    public String toString() {
        return this.getRequestPath() + ":" + this.getLocatorPath();
    }

    public String getRequestPath() {
        return this.requestPath;
    }
}

