package jp.sf.pal.ggadget.pager;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import jp.sf.pal.ggadget.GGadgetConstants;

public class GGadgetPager implements Serializable {

    private static final long serialVersionUID = 237701365907034437L;

    private int start = 0;

    private int num = 20;

    private String category;

    private String query;

    private String language = "en";

    public void reset() {
        start = 0;
        num = 20;
        category = null;
        query = null;
        language = "en";
    }

    public String buildUrl() {
        StringBuilder url = new StringBuilder(GGadgetConstants.BASE_URL);

        url.append("&start=").append(start);
        url.append("&num=").append(num);
        if (category != null) {
            url.append("&cat=").append(category);
        }
        if (query != null && !"".equals(query)) {
            try {
                url.append("&q=").append(URLEncoder.encode(query, "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                // TODO
            }
        }
        if (language != null) {
            url.append("&lang=").append(language);
        }
        return url.toString();
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}
