package jp.sf.pal.ggadget.util;

import java.util.ArrayList;
import java.util.List;

import jp.sf.pal.ggadget.entity.GGadget;
import jp.sf.pal.ggadget.pager.GGadgetPager;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GGadgetHandler extends DefaultHandler {

    private GGadgetList<GGadget> gGadgetList;

    private GGadget gGadget;

    private List<String> stack;

    private GGadgetPager gGadgetPager;

    public GGadgetHandler(GGadgetPager gGadgetPager) {
        super();
        this.gGadgetPager = gGadgetPager;
    }

    @Override
    public void startDocument() throws SAXException {
        stack = new ArrayList<String>();
    }

    @Override
    public void endDocument() throws SAXException {
        stack = null;
    }

    @Override
    public void startElement(String uri, String localName, String name,
            Attributes attributes) throws SAXException {
        stack.add(name);

        if ("channel".equals(name)) {
            gGadgetList = new GGadgetList<GGadget>();

            if (gGadgetPager.getStart() > 0) {
                gGadgetList.setExistPrevPage(true);
            } else {
                gGadgetList.setExistPrevPage(false);
            }

            gGadgetList.setCurrentPageNumber(gGadgetPager.getStart()
                    / gGadgetPager.getNum() + 1);

        } else if ("item".equals(name)) {
            gGadget = new GGadget();
            gGadget.setId(gGadgetList.size() + 1);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name)
            throws SAXException {
        if ("item".equals(name)) {
            gGadgetList.add(gGadget);
            gGadget = null;
        }

        stack.remove(stack.size() - 1);
    }

    @Override
    public void characters(char[] ch, int start, int length)
            throws SAXException {
        if (stack != null) {
            String tagName = stack.get(stack.size() - 1);
            if (gGadget != null) {
                if ("title".equals(tagName)) {
                    gGadget.setName(gGadget.getName()
                            + new String(ch, start, length));
                } else if ("guid".equals(tagName)) {
                    gGadget.setUrl(new String(ch, start, length));
                } else if ("description".equals(tagName)) {
                    gGadget.setDescription(gGadget.getDescription()
                            + new String(ch, start, length));
                } else if ("ghapi:thumbnail".equals(tagName)) {
                    gGadget.setThumbnail(new String(ch, start, length));
                }
            } else {
                if ("ghapi:num_items".equals(tagName)) {
                    int numOfAll = Integer.parseInt(new String(ch, start,
                            length));
                    gGadgetList.setAllRecordCount(numOfAll);

                    if (gGadgetPager.getStart() + gGadgetPager.getNum() < numOfAll) {
                        gGadgetList.setExistNextPage(true);
                    } else {
                        gGadgetList.setExistNextPage(false);
                    }

                    int pageNum = numOfAll / gGadgetPager.getNum();
                    if (numOfAll % gGadgetPager.getNum() != 0) {
                        pageNum++;
                    }
                    gGadgetList.setAllPageCount(pageNum);

                }
            }
        }
    }

    public GGadgetList<GGadget> getGGadgetList() {
        return gGadgetList;
    }
}
