/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.action;

import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.Resources;
import org.seasar.framework.util.MethodUtil;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.config.S2ValidationConfig;
import org.seasar.struts.enums.SaveType;
import org.seasar.struts.util.ActionFormUtil;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;
import org.seasar.struts.util.ServletContextUtil;

public class ActionWrapper
extends Action {
    protected S2ActionMapping actionMapping;
    protected Object action;
    protected Object actionForm;

    public ActionWrapper(S2ActionMapping actionMapping) {
        this.actionMapping = actionMapping;
        this.action = actionMapping.getAction();
        this.actionForm = actionMapping.getActionForm();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        S2ExecuteConfig executeConfig = S2ExecuteConfigUtil.getExecuteConfig();
        if (executeConfig != null) {
            return this.execute(request, executeConfig);
        }
        return null;
    }

    protected ActionForward execute(HttpServletRequest request, S2ExecuteConfig executeConfig) {
        ActionMessages errors = new ActionMessages();
        List<S2ValidationConfig> validationConfigs = executeConfig.getValidationConfigs();
        if (validationConfigs != null) {
            for (S2ValidationConfig cfg : validationConfigs) {
                ActionMessages errors2;
                if (cfg.isValidator()) {
                    ActionMessages errors22 = this.validateUsingValidator(request, executeConfig);
                    if (errors22 == null || errors22.isEmpty()) continue;
                    errors.add(errors22);
                    if (!executeConfig.isStopOnValidationError()) continue;
                    return this.processErrors(errors, request, executeConfig);
                }
                Object target = this.actionForm;
                if (cfg.getValidateMethod().getDeclaringClass() == this.actionMapping.getComponentDef().getComponentClass()) {
                    target = this.action;
                }
                if ((errors2 = (ActionMessages)MethodUtil.invoke((Method)cfg.getValidateMethod(), (Object)target, null)) == null || errors2.isEmpty()) continue;
                errors.add(errors2);
                if (!executeConfig.isStopOnValidationError()) continue;
                return this.processErrors(errors, request, executeConfig);
            }
        }
        if (!errors.isEmpty()) {
            return this.processErrors(errors, request, executeConfig);
        }
        String next = (String)MethodUtil.invoke((Method)executeConfig.getMethod(), (Object)this.action, null);
        if (executeConfig.isRemoveActionForm()) {
            RequestUtil.getRequest().getSession().removeAttribute(this.actionMapping.getActionFormComponentDef().getComponentName());
            RequestUtil.getRequest().removeAttribute(this.actionMapping.getAttribute());
        }
        return this.actionMapping.createForward(next, executeConfig.isRedirect());
    }

    protected ActionMessages validateUsingValidator(HttpServletRequest request, S2ExecuteConfig executeConfig) {
        ServletContext application = ServletContextUtil.getServletContext();
        ActionMessages errors = new ActionMessages();
        String validationKey = this.actionMapping.getName() + "_" + executeConfig.getMethod().getName();
        Validator validator = Resources.initValidator((String)validationKey, (Object)ActionFormUtil.getActionForm(request, this.actionMapping), (ServletContext)application, (HttpServletRequest)request, (ActionMessages)errors, (int)0);
        try {
            validator.validate();
        }
        catch (ValidatorException e) {
            throw new RuntimeException(e);
        }
        return errors;
    }

    protected ActionForward processErrors(ActionMessages errors, HttpServletRequest request, S2ExecuteConfig executeConfig) {
        if (executeConfig.getSaveErrors() == SaveType.REQUEST) {
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        } else {
            request.getSession().setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        }
        return this.actionMapping.createForward(executeConfig.resolveInput(this.actionMapping));
    }
}

