/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.LRUMap;
import org.apache.struts.action.ActionServlet;
import org.seasar.framework.container.filter.S2ContainerFilter;
import org.seasar.framework.container.hotdeploy.HotdeployFilter;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.portlet.config.ProcessActionConfig;
import org.seasar.struts.portlet.filter.PortletRoutingFilter;
import org.seasar.struts.portlet.servlet.SAStrutsActionRequest;
import org.seasar.struts.portlet.servlet.SAStrutsActionResponse;
import org.seasar.struts.portlet.servlet.SAStrutsConfig;
import org.seasar.struts.portlet.servlet.SAStrutsFilterChain;
import org.seasar.struts.portlet.util.PortletUtil;

public class SAStrutsPortlet
extends GenericPortlet {
    protected static final String HELP_PAGE = "helpPage";
    protected static final String EDIT_PAGE = "editPage";
    protected static final String VIEW_PAGE = "viewPage";
    protected static final String CONTENT_TYPE = "contentType";
    protected static final String MAX_CACHE_SIZE = "maxCacheSize";
    protected static final String ENCODING = "encoding";
    protected static final String PREVIOUS_PORTLET_MODE = "previousPortletMode";
    protected String defaultViewPage;
    protected String defaultEditPage;
    protected String defaultHelpPage;
    protected String contentType;
    protected SAStrutsConfig saStrutsConfig;
    protected SAStrutsFilterChain saStrutsFilterChain;
    protected int maxCacheSize;
    protected String encoding;

    public void init() throws PortletException {
        this.defaultViewPage = this.getViewPage();
        this.defaultEditPage = this.getEditPage();
        this.defaultHelpPage = this.getHelpPage();
        this.contentType = this.getContentType();
        this.maxCacheSize = this.getMaxCacheSize();
        this.encoding = this.getCharacterEncoding();
        this.saStrutsConfig = new SAStrutsConfig(this.getPortletConfig());
        this.saStrutsFilterChain = this.createFilterChain((Servlet)this.createActionServlet());
    }

    protected SAStrutsFilterChain createFilterChain(Servlet servlet) {
        SAStrutsFilterChain saStrutsFilterChain = new SAStrutsFilterChain(servlet);
        S2ContainerFilter s2ContainerFilter = new S2ContainerFilter();
        saStrutsFilterChain.addFilter((Filter)s2ContainerFilter);
        HotdeployFilter hotdeployFilter = new HotdeployFilter();
        saStrutsFilterChain.addFilter((Filter)hotdeployFilter);
        PortletRoutingFilter routingFilter = new PortletRoutingFilter();
        saStrutsFilterChain.addFilter((Filter)routingFilter);
        return saStrutsFilterChain;
    }

    protected ActionServlet createActionServlet() throws PortletException {
        ActionServlet actionServlet = (ActionServlet)this.getPortletContext().getAttribute("org.seasar.struts.portlet.action_servlet");
        if (actionServlet == null) {
            throw new PortletException("ActionServlet is null.");
        }
        return actionServlet;
    }

    public void destroy() {
        this.saStrutsConfig = null;
        this.saStrutsFilterChain = null;
    }

    protected String getViewPage() {
        return this.getPortletConfig().getInitParameter(VIEW_PAGE);
    }

    protected String getEditPage() {
        return this.getPortletConfig().getInitParameter(EDIT_PAGE);
    }

    protected String getHelpPage() {
        return this.getPortletConfig().getInitParameter(HELP_PAGE);
    }

    protected String getContentType() {
        return this.getPortletConfig().getInitParameter(CONTENT_TYPE);
    }

    protected String getCharacterEncoding() {
        String encoding = this.getPortletConfig().getInitParameter(ENCODING);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    protected int getMaxCacheSize() {
        int size = 10;
        String value = this.getPortletConfig().getInitParameter(MAX_CACHE_SIZE);
        if (value != null) {
            try {
                size = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return size;
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.renderRequest(request, response, this.defaultEditPage);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.renderRequest(request, response, this.defaultHelpPage);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.renderRequest(request, response, this.defaultViewPage);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletUtil.setSAStrutsStarted((PortletRequest)request);
        String requestPath = request.getParameter("org.seasar.struts.portlet.request_url");
        if (requestPath == null) {
            return;
        }
        Integer accessId = this.getAccessId((PortletRequest)request);
        if (this.getProcessActionConfig((PortletRequest)request, accessId) != null) {
            return;
        }
        request.setAttribute("javax.portlet.request", (Object)request);
        request.setAttribute("javax.portlet.response", (Object)response);
        request.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
        ProcessActionConfig processActionConfig = new ProcessActionConfig(requestPath, request.getContextPath(), this.encoding);
        HashMap parameterMap = new HashMap();
        parameterMap.putAll(request.getParameterMap());
        processActionConfig.setParameterMap(parameterMap);
        SAStrutsActionRequest saStrutsActionRequest = new SAStrutsActionRequest(request, this.saStrutsConfig, processActionConfig);
        SAStrutsActionResponse saActionResponse = new SAStrutsActionResponse(request, response, this.getPortletContext());
        this.process(saStrutsActionRequest, saActionResponse);
        String forwardPath = (String)request.getAttribute("org.seasar.struts.portlet.forward_path");
        if (forwardPath != null) {
            processActionConfig.setForwardPath(forwardPath);
        }
        if (request.getAttribute("org.seasar.struts.portlet.error_status") != null) {
            processActionConfig.getAttributeMap().put("org.seasar.struts.portlet.error_status", request.getAttribute("org.seasar.struts.portlet.error_status"));
            Object msg = request.getAttribute("org.seasar.struts.portlet.error_message");
            if (msg != null) {
                processActionConfig.getAttributeMap().put("org.seasar.struts.portlet.error_message", msg);
            }
        }
        this.putProcessActionConfig((PortletRequest)request, accessId, processActionConfig);
        if (request.getAttribute("org.seasar.struts.portlet.redirect") == null) {
            response.setRenderParameter("org.seasar.struts.portlet.access_id", accessId.toString());
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, PortletException {
        this.saStrutsFilterChain.reset();
        try {
            this.saStrutsFilterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void renderRequest(RenderRequest request, RenderResponse response, String defaultPage) throws PortletException, IOException {
        PortletUtil.setSAStrutsStarted((PortletRequest)request);
        Integer accessId = this.getAccessId((PortletRequest)request);
        ProcessActionConfig processActionConfig = this.createProcessActionConfig(request, accessId, defaultPage, request.getContextPath());
        request.setAttribute("org.seasar.struts.portlet.process_action_config", (Object)processActionConfig);
        Integer sc = (Integer)processActionConfig.getAttributeMap().get("org.seasar.struts.portlet.error_status");
        if (sc != null) {
            response.setContentType("text/html");
            this.sendError(response, sc, (String)processActionConfig.getAttributeMap().get("org.seasar.struts.portlet.error_message"));
            return;
        }
        String requestPath = this.getRequestPath((PortletRequest)request);
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(requestPath);
        portletRequestDispatcher.include(request, response);
        String cType = (String)request.getAttribute("org.seasar.struts.portlet.content_type");
        if (cType == null && (cType = this.contentType) == null) {
            cType = "text/html";
        }
        response.setContentType(cType);
        sc = (Integer)request.getAttribute("org.seasar.struts.portlet.error_status");
        if (sc != null) {
            this.sendError(response, sc, (String)request.getAttribute("org.seasar.struts.portlet.error_message"));
        } else {
            response.getWriter().print(request.getAttribute("org.seasar.struts.portlet.content"));
            response.flushBuffer();
        }
        this.putProcessActionConfig((PortletRequest)request, PortletUtil.getAccessId((PortletRequest)request), processActionConfig);
        PortletUtil.incrementAccessId((PortletRequest)request);
    }

    protected void sendError(RenderResponse response, Integer sc, String msg) throws IOException {
        StringBuilder sb = new StringBuilder("HTTP Status ");
        sb.append(sc);
        if (msg != null) {
            sb.append(" - ");
            sb.append(msg);
        }
        response.getWriter().print(sb.toString());
        response.flushBuffer();
    }

    protected ProcessActionConfig createProcessActionConfig(RenderRequest request, Integer accessId, String requestUrl, String contextPath) {
        ProcessActionConfig processActionConfig = this.getProcessActionConfig((PortletRequest)request, accessId);
        if (processActionConfig != null && processActionConfig.getForwardPath() != null) {
            StringBuilder buf = new StringBuilder(processActionConfig.getServletPath());
            if (processActionConfig.getQueryString() != null) {
                buf.append("?");
                buf.append(processActionConfig.getQueryString());
            }
            request.setAttribute("org.seasar.struts.portlet.request_url", (Object)buf.toString());
            request.setAttribute("org.seasar.struts.portlet.forward_path", (Object)processActionConfig.getForwardPath());
        } else if (processActionConfig != null) {
            request.setAttribute("org.seasar.struts.portlet.request_url", (Object)processActionConfig.getRequestURL());
        } else {
            StringBuilder buf = new StringBuilder();
            if (!StringUtil.isEmpty((String)contextPath)) {
                buf.append(contextPath);
            }
            buf.append(requestUrl);
            processActionConfig = new ProcessActionConfig(buf.toString(), contextPath, this.encoding);
            request.setAttribute("org.seasar.struts.portlet.request_url", (Object)requestUrl);
        }
        return processActionConfig;
    }

    protected String getRequestPath(PortletRequest request) {
        String requestPath = (String)request.getAttribute("org.seasar.struts.portlet.request_url");
        if (requestPath == null && (requestPath = request.getParameter("org.seasar.struts.portlet.request_url")) == null) {
            return null;
        }
        return requestPath;
    }

    protected void putProcessActionConfig(PortletRequest request, Integer accessId, ProcessActionConfig processActionConfig) {
        PortletSession portletSession = request.getPortletSession();
        Map configMap = (Map)portletSession.getAttribute("org.seasar.struts.portlet.process_action_config_map");
        if (configMap == null) {
            configMap = new LRUMap(this.maxCacheSize);
            portletSession.setAttribute("org.seasar.struts.portlet.process_action_config_map", (Object)configMap);
        }
        configMap.put(accessId, processActionConfig);
    }

    protected ProcessActionConfig getProcessActionConfig(PortletRequest request, Integer accessId) {
        PortletSession portletSession = request.getPortletSession();
        String currentPortletMode = request.getPortletMode().toString();
        String previousPortletMode = (String)portletSession.getAttribute(PREVIOUS_PORTLET_MODE);
        portletSession.setAttribute(PREVIOUS_PORTLET_MODE, (Object)currentPortletMode);
        if (this.isPortletModeChange(currentPortletMode, previousPortletMode)) {
            portletSession.setAttribute("org.seasar.struts.portlet.process_action_config_map", (Object)new LRUMap(this.maxCacheSize));
            return null;
        }
        Map configMap = (Map)portletSession.getAttribute("org.seasar.struts.portlet.process_action_config_map");
        if (configMap == null) {
            configMap = new LRUMap(this.maxCacheSize);
            portletSession.setAttribute("org.seasar.struts.portlet.process_action_config_map", (Object)configMap);
        }
        return (ProcessActionConfig)configMap.get(accessId);
    }

    protected Integer getAccessId(PortletRequest request) {
        Integer accessId = PortletUtil.getAccessId(request);
        String accessIdString = request.getParameter("org.seasar.struts.portlet.access_id");
        if (accessIdString != null) {
            try {
                accessId = Integer.parseInt(accessIdString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return accessId;
    }

    private boolean isPortletModeChange(String currentMode, String previousMode) {
        if (previousMode == null) {
            return false;
        }
        return !previousMode.equals(currentMode);
    }
}

