/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.config;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.StringUtil;

public class ProcessActionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String pathInfo;
    private String queryString;
    private String requestURI;
    private String servletPath;
    private String contextPath;
    private String characterEncoding;
    private Map parameterMap;
    private Map attributeMap;
    private String forwardPath;
    private transient Map queryParameterMap;
    private transient Map cachedParameterMap;

    public ProcessActionConfig(String requestUrl, String contextPath, String characterEncoding) {
        this.init(requestUrl, contextPath, characterEncoding);
    }

    public void init(String requestUrl, String contextPath, String characterEncoding) {
        this.contextPath = contextPath;
        int qPos = requestUrl.indexOf("?");
        if (qPos == -1) {
            this.requestURI = requestUrl;
            this.queryString = null;
        } else {
            this.requestURI = requestUrl.substring(0, qPos);
            this.queryString = requestUrl.substring(qPos + 1);
        }
        if (!StringUtil.isEmpty((String)contextPath)) {
            this.servletPath = this.requestURI.substring(contextPath.length());
        }
        this.parameterMap = new HashMap();
        this.attributeMap = new HashMap();
        this.forwardPath = null;
        this.characterEncoding = characterEncoding;
        this.parseQueryParameterMap();
    }

    public String getRequestURL() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.requestURI);
        if (this.pathInfo != null) {
            buf.append(this.pathInfo);
        }
        if (this.queryString != null) {
            buf.append("?");
            buf.append(this.queryString);
        }
        return buf.toString();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.parseQueryParameterMap();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public Map getParameterMap() {
        if (this.cachedParameterMap == null) {
            this.cachedParameterMap = new HashMap();
            this.cachedParameterMap.putAll(this.parameterMap);
            if (this.queryParameterMap == null) {
                this.parseQueryParameterMap();
            }
            this.cachedParameterMap.putAll(this.queryParameterMap);
        }
        return this.cachedParameterMap;
    }

    public void setParameterMap(Map parameterMap) {
        this.parameterMap = parameterMap;
        this.cachedParameterMap = null;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map attributeMap) {
        this.attributeMap = attributeMap;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public void setForwardPath(String forwardPath) {
        this.forwardPath = forwardPath;
    }

    public void parseQueryParameterMap() {
        this.cachedParameterMap = null;
        this.queryParameterMap = new HashMap();
        if (this.queryString == null) {
            return;
        }
        String[] pairs = this.queryString.split("&");
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i].split("=");
            if (pair.length != 2) continue;
            try {
                this.queryParameterMap.put(URLDecoder.decode(pair[0], this.characterEncoding), URLDecoder.decode(pair[1], this.characterEncoding));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.queryParameterMap.put(pair[0], pair[1]);
            }
        }
    }
}

