/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.filter;

import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.struts.portlet.config.ProcessActionConfig;
import org.seasar.struts.portlet.servlet.SAStrutsRenderRequest;
import org.seasar.struts.portlet.servlet.SAStrutsRenderResponse;
import org.seasar.struts.portlet.servlet.TemporaryOutputStream;
import org.seasar.struts.portlet.util.PortletUtil;

public class PortletRequestFilter
implements Filter {
    protected static final String DONE = "org.seasar.struts.portlet.filter.PortletRequestFilter.done";
    private static final String CONTENT_ONLY = "contentOnly";
    protected boolean contentOnly;
    protected ServletContext servletContext;

    public void init(FilterConfig config) throws ServletException {
        String value = config.getInitParameter(CONTENT_ONLY);
        this.contentOnly = value == null || !"false".equalsIgnoreCase(value);
        this.servletContext = config.getServletContext();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (PortletUtil.isPortletRequest(request)) {
            PortletRequest portletRequest = PortletUtil.getPortletRequest(request);
            if (PortletUtil.isSAStrutsStarted(request) && portletRequest.getAttribute(DONE) == null) {
                portletRequest.setAttribute(DONE, (Object)Boolean.TRUE);
                ProcessActionConfig processActionConfig = (ProcessActionConfig)portletRequest.getAttribute("org.seasar.struts.portlet.process_action_config");
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                SAStrutsRenderRequest saStrutsRequest = new SAStrutsRenderRequest(httpServletRequest, this.servletContext, processActionConfig);
                SAStrutsRenderResponse saStrutsResponse = new SAStrutsRenderResponse(httpServletRequest, httpServletResponse, this.servletContext);
                chain.doFilter((ServletRequest)saStrutsRequest, (ServletResponse)saStrutsResponse);
                portletRequest.setAttribute("org.seasar.struts.portlet.content_type", (Object)response.getContentType());
                portletRequest.setAttribute("org.seasar.struts.portlet.content", (Object)this.getContent(saStrutsResponse.getTemporaryOutputStream()));
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected String getContent(TemporaryOutputStream tos) {
        String content = tos.toString();
        if (this.contentOnly) {
            int bodyBeginIdx = content.indexOf("<body");
            if (bodyBeginIdx == -1) {
                bodyBeginIdx = content.indexOf("<BODY");
            }
            if (bodyBeginIdx != -1) {
                bodyBeginIdx = content.indexOf(">", bodyBeginIdx);
            }
            ++bodyBeginIdx;
            int bodyEndIdx = content.indexOf("</body");
            if (bodyEndIdx == -1) {
                bodyEndIdx = content.indexOf("</BODY");
            }
            content = bodyEndIdx == -1 ? content.substring(bodyBeginIdx) : content.substring(bodyBeginIdx, bodyEndIdx);
        }
        return content;
    }
}

