/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SAStrutsFilterChain
implements FilterChain {
    public static final int INCREMENT = 10;
    private Servlet servlet;
    private ThreadLocal<Integer> filterPosition = new ThreadLocal();
    private Filter[] filters = new Filter[0];
    private int n = 0;

    public SAStrutsFilterChain(Servlet servlet) {
        this.servlet = servlet;
    }

    public void addFilter(Filter filter) {
        if (filter != null) {
            if (this.n == this.filters.length) {
                Filter[] newFilters = new Filter[this.n + 10];
                System.arraycopy(this.filters, 0, newFilters, 0, this.n);
                this.filters = newFilters;
            }
            this.filters[this.n++] = filter;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        int pos = this.filterPosition.get();
        if (pos < this.n) {
            Filter filter = this.filters[pos++];
            this.filterPosition.set(pos);
            filter.doFilter(request, response, (FilterChain)this);
            this.filterPosition.set(--pos);
            return;
        }
        this.servlet.service(request, response);
    }

    public void reset() {
        this.filterPosition.set(0);
    }
}

