/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.seasar.struts.portlet.servlet.SAStrutsResponse;
import org.seasar.struts.portlet.servlet.TemporaryOutputStream;

public class SAStrutsRenderResponse
extends HttpServletResponseWrapper
implements SAStrutsResponse {
    private static final int DEFAULT_STREAM_SIZE = 4096;
    private TemporaryOutputStream tos = new TemporaryOutputStream(4096);
    private PrintWriter printWriter;
    private HttpServletRequest request;
    private ServletContext servletContext;

    public SAStrutsRenderResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(response);
        this.request = request;
        this.servletContext = servletContext;
    }

    public TemporaryOutputStream getTemporaryOutputStream() {
        return this.tos;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.tos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter((OutputStream)((Object)this.tos), true);
        } else {
            this.printWriter.flush();
        }
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        this.tos.flush();
    }

    public int getBufferSize() {
        return this.tos.size();
    }

    public boolean isCommitted() {
        return this.tos.isClose();
    }

    public void reset() {
        this.tos.reset();
        super.reset();
    }

    public void resetBuffer() {
        this.tos.reset();
    }

    public void setBufferSize(int size) {
        if (this.tos.size() > 0) {
            throw new IllegalStateException("Content has been written.");
        }
        this.tos = new TemporaryOutputStream(size);
    }

    public void sendError(int sc) throws IOException {
        super.sendError(sc);
        this.servletContext.log("HTTP Status " + sc);
        this.request.setAttribute("org.seasar.struts.portlet.error_status", (Object)sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        this.servletContext.log("HTTP Status " + sc + " - " + msg);
        this.request.setAttribute("org.seasar.struts.portlet.error_status", (Object)sc);
        this.request.setAttribute("org.seasar.struts.portlet.error_message", (Object)msg);
    }
}

