/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.taglib;

import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.portlet.util.PortletUtil;
import org.seasar.struts.taglib.S2Functions;
import org.seasar.struts.util.ActionUtil;
import org.seasar.struts.util.RoutingUtil;

public class S2LinkTag
extends org.seasar.struts.taglib.S2LinkTag {
    protected static final String ACTION_URL_TYPE = "action";
    protected static final String RENDER_URL_TYPE = "render";
    protected static final String RESOURCE_URL_TYPE = "resource";
    private String urlType = null;

    public String getUrlType() {
        return this.urlType;
    }

    public void setUrlType(String urlType) {
        this.urlType = urlType;
    }

    protected String calculateURL() throws JspException {
        if (this.href != null) {
            int index = this.href.indexOf(58);
            if (index > -1) {
                return super.calculateURL();
            }
            if (PortletUtil.isPortletRequest(this.pageContext.getRequest())) {
                RenderResponse renderResponse = PortletUtil.getRenderResponse(this.pageContext.getRequest());
                if (renderResponse != null) {
                    if (RESOURCE_URL_TYPE.equals(this.urlType)) {
                        return S2Functions.url((String)this.href);
                    }
                    PortletURL portletURL = ACTION_URL_TYPE.equals(this.urlType) ? renderResponse.createActionURL() : (RENDER_URL_TYPE.equals(this.urlType) ? renderResponse.createRenderURL() : renderResponse.createActionURL());
                    portletURL.setParameter("org.seasar.struts.portlet.request_url", this.functionsUrl(this.href));
                    portletURL.setParameter("org.seasar.struts.portlet.access_id", Integer.valueOf(PortletUtil.getAccessId(this.pageContext.getRequest()) + 1).toString());
                    return portletURL.toString();
                }
            } else {
                return S2Functions.url((String)this.href);
            }
        }
        return super.calculateURL();
    }

    protected String functionsUrl(String input) {
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        StringBuilder sb = new StringBuilder();
        if (contextPath.length() > 1) {
            sb.append(contextPath);
        }
        if (StringUtil.isEmpty((String)input)) {
            sb.append(ActionUtil.calcActionPath());
        } else if (!input.startsWith("/")) {
            sb.append(ActionUtil.calcActionPath()).append(input);
        } else {
            String[] names = StringUtil.split((String)input, (String)"/");
            S2Container container = SingletonS2ContainerFactory.getContainer();
            StringBuilder sb2 = new StringBuilder(50);
            String input2 = input;
            for (int i = 0; i < names.length; ++i) {
                if (container.hasComponentDef((Object)(sb2 + names[i] + "Action"))) {
                    String actionPath = RoutingUtil.getActionPath((String[])names, (int)i);
                    String paramPath = RoutingUtil.getParamPath((String[])names, (int)(i + 1));
                    if (StringUtil.isEmpty((String)paramPath)) {
                        input2 = actionPath + "/";
                        break;
                    }
                }
                sb2.append(names[i] + "_");
            }
            sb.append(input2);
        }
        return sb.toString();
    }

    public void release() {
        super.release();
        this.urlType = null;
    }
}

