#
# referenciate.rb:
# a library to markup text with HTML references
#
# $Id: referenciate.rb,v 1.3 2007/01/26 03:16:54 zunda Exp $
#
# Copyright:: Copyright (C) 2007 zunda <zunda at freeshell.org>
# License:: GPL
#
require 'entity-reference/references.rb'

module EntityReference
	Lists_to_apply = {
		/\Aiso-8859-1\Z/i => ['iso-8859-1', 'internationalization'],
		/\Autf-8\Z/i => ['utf-8'],
	}
	Not_on_html = {	# We will not convert
		"\x22" => true,	# "
		"\x26" => true,	# &
		"\x3c" => true,	# <
		"\x3e" => true,	# >
	}

	def lists(charset)
		Lists_to_apply.each_pair do |regex, lists|
			return lists if regex =~ charset
		end
		return nil
	end

	def referenciate(string, encoding = 'html', charset = 'iso-8859-1')
		l = lists(charset)
		return string unless l

		no_conv = ('html' == encoding) ? Not_on_html : {}
		re = (/\Autf-/i =~ charset) ? /./u : /./n

		result = ''
		string.scan(re).each do |char|
			unless no_conv[char]
				l.each do |k|
					if References[k].has_key?(char)
						char = References[k][char]
						break
					end
				end
			end
			result += char
		end
		return result
	end

end
