$:.unshift('lib')
require 'entity-reference/referenciate'
require 'test/unit'

class TestReferenciate < Test::Unit::TestCase
	include EntityReference

	def conversion_test(hash, enc, charset)
		hash.each_pair do |src, target|
			assert_equal(target, referenciate(src, enc, charset), "text/#{enc}; charset=#{charset}")
		end
	end

	def test_plain_iso8859_1
		conversion_test({
			'<the Answer to life the universe & everything> is 42.' =>
			'&lt;the Answer to life the universe &amp; everything&gt; is 42.',
			"Gr\xfc\xdf Gott" => 'Gr&uuml;&szlig; Gott',	# Hello in Southern German
			"Fran\xe7ais" => 'Fran&ccedil;ais',
		}, 'plain', 'iso-8859-1')
	end

	def test_plain_iso8859_7
		conversion_test({
			"Greek / \xc7\xeb\xeb\xdd\xed\xe9\xea" => "Greek / \xc7\xeb\xeb\xdd\xed\xe9\xea",
		}, 'plain', 'iso-8859-7')
	end

	def test_plain_euc_jp
		conversion_test({
			"\xc6\xfc\xcb\xdc\xb8\xec" => "\xc6\xfc\xcb\xdc\xb8\xec",	# Japanese
		}, 'plain', 'euc-jp')
	end

	def test_html_iso8859_1
		conversion_test({
			'<p>&lt;the Answer to life the universe &amp; everything&gt; is 42.</p>' =>
			'<p>&lt;the Answer to life the universe &amp; everything&gt; is 42.</p>',
		}, 'html', 'iso-8859-1')
	end

	def test_plain_utf_8
		conversion_test({
			"The quick brown fox jumps over the lazy dog." =>
			'The quick brown fox jumps over the lazy dog.',
			"Falsches \xc3\x9cben von Xylophonmusik qu\xc3\xa4lt jeden gr\xc3\xb6\xc3\x9feren Zwerg." =>
			"Falsches &Uuml;ben von Xylophonmusik qu&auml;lt jeden gr&ouml;&szlig;eren Zwerg.",
			"Bonjour \xc3\xa0 tous!" =>
			'Bonjour &agrave; tous!',
		}, 'plain', 'utf-8')
	end


end
