/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.facade;

import java.util.List;

import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.dao.IssueDAO;
import jp.valtech.bts.data.IssueType;
import jp.valtech.bts.util.Logging;

/**
 * 同期処理用のFacadeクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class SyncHeaderFacade implements Logging {

	/** 通常の課題票ヘッダ情報 */
	private List issueHeaderList;
	
	/** ごみ箱の課題票ヘッダ情報 */
	private List garbageHeaderList;
	
	/**
	 * 何もしない。
	 */
	public SyncHeaderFacade() {
		// DBコネクション取得
		IssueDBConnection dbcon = new IssueDBConnection();

		try {
			IssueDAO dao = new IssueDAO( dbcon );
		
			// 通常の課題票のヘッダ取得
			this.issueHeaderList   =  dao.getIssueSyncHeaders(IssueType.RELEASE_VALUE);

			// ごみ箱に入った課題票のヘッダ取得
			this.garbageHeaderList = dao.getGarbageSyncList();

		}catch (Exception e) {
			logger.fatal(e.getMessage(), e);
		} finally {
			dbcon.close();
			dbcon = null;
		}
	}

	/**
	 * 同期用の課題票ヘッダ情報を取得します。
	 * 
	 * @return		課題票ヘッダ情報
	 */
	public List getIssueHeaderList() {
		return this.issueHeaderList;
	}
	
	/**
	 * 同期用のごみ箱入り課題票ヘッダ情報を取得します。
	 * 
	 * @return		課題票ヘッダ情報
	 */
	public List getGarbageHeaderList() {
		return this.garbageHeaderList;
	}
}