/*
 * Copyright(C) 2006-2007 Valtech Corporation. All Rights Reserved.
 * 
 * $URL$
 * $Id$
 * 
 */
package jp.valtech.bts.command.server;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.Response;
import jp.valtech.bts.network.command.TCPServerCommand;


/**
 * <dl>
 *   <dt><b>クライアントからのPINGリクエストを受け付けます。</b></dt>
 *   <dd><ul>クライアントからのPING要求を受け取り、指定のSSIDが自端末でカレントプロジェクトであれば
 *   {@link jp.valtech.bts.network.Response#OK}を返します。
 *   </ul></dd>
 * </dl>
 * 
 * @see			jp.valtech.bts.command.client.Ping
 * @author		<A href="mailto:m_sugitou@valtech.jp">M_Sugito</A>
 * @version		Ver0.8
 */
public class PingServer extends TCPServerCommand implements Runnable {

	/**
	 * なにもしない。
	 */
	public PingServer() {
		super();
	}

	
	/**
	 * 指定のSSIDが、自端末でカレントプロジェクトであれば{@link jp.valtech.bts.network.Response#OK}を返します。
	 * 
	 * @param		request			リクエストオブジェクト
	 * @param		response		レスポンスオブジェクト
	 * @param		myconfig		ローカル端末のネットワーク情報
	 */
	public void execute(Request request, Response response, NetworkConfig myconfig){
		
		// SSIDを取得。
		String requestSSID = request.getSSID();
		String currentSSID = CurrentProject.getInsance().getSSID();

		// SSIDをチェック。違うプロジェクトからのリクエストはエラーとして返す
		if(requestSSID.equals(currentSSID) ) {
			response.setCode(Response.OK);
		} else {
			response.setCode(Response.ERROR);
		}
		reply(response);
	}
}
