/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;



/**
 * <dl><dt><b>課題票データ</b></dt>
 * 	<dd></dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class Issue implements Serializable {

	private static final String ISSUID_SEPARATOR  = "#";
	
	/** シリアルID　*/
	private static final long serialVersionUID = -3116949077223546596L;

	/** 完了期限：まだ余裕 */
	public static final int DEADLINE_SAFE 		= 0;
	/** 完了期限：迫っている */
	public static final int DEADLINE_WARNING 	= 1;
	/** 完了期限：切れている */
	public static final int DEADLINE_OVER 		= 2;
	
	
	/** 課題票ID :  */
	private int issueID = 0;

	/** 指紋 : 課題票を一意に識別するためのSHA-1フィンガープリント */
	private String fingerPrint = null;

	/** 種別 :  */
	private String type  = null;

	/** カテゴリ :  */
	private String category = null;

	/** タイトル :  */
	private String title = null;

	/** 詳細 :  */
	private String description = null;

	/** 優先度 :  */
	private String priority = null;

	/** 完了期限 :  */
	private Date deadline = null;

	/** ステータス :  */
	private String status = null;

	/** 担当者 :  */
	private String assigned = null;

	/** 内緒のバグ :  */
	private Boolean secretBug = null;

	/** 保留 :  */
	private Boolean suspend = null;

	/** レコード作製者 : このレコードを作製したユーザID */
	private String createUser = null;

	/** レコード作製タイムスタンプ : このレコードを作製した日時のタイムスタンプ */
	private Date createDate = null;

	/** レコード更新タイムスタンプ : このレコードを更新した日時のタイムスタンプ */
	private Date updateDate = null;

	/** バージョン番号 : 更新したらインクリメントする通し番号 */
	private Integer version = new Integer(0);

	/** 添付ファイル */
	private ArrayList attachmentList = new ArrayList();

	/** 課題票履歴 */
	private IssueHistory[] issueHistory = null;

	/** コメント履歴 */
	private CommentHistory[] commentHistory = null;
	
	/** 投票 */
	private Vote[] votes = null;
	
	/** 自分が更新した回数 */
	private int updateCnt = 0;

	
	public Issue() {
		
	}
	/**
	 * <DL>
	 * <DT><B>課題票ID を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 課題票ID 
	 */
	public int getIssueID() {
		return this.issueID;
	}

	public String getDisplayIssueID() {
		if(issueID == 0 ) {
			return "";
		}
		return category + ISSUID_SEPARATOR + issueID;

	}
	
	/**
	 * <DL>
	 * <DT><B>課題票IDを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param issueID 課題票ID
	 */
	public void setIssueID( int issueID ) {
		this.issueID = issueID;
	}
	
	
	/**
	 * <DL>
	 * <DT><B>指紋 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 指紋 
	 */
	public String getFingerPrint() {
		return this.fingerPrint;
	}

	/**
	 * <DL>
	 * <DT><B>指紋を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param fingerPrint 指紋
	 */
	public void setFingerPrint( String fingerPrint ) {
		if(this.fingerPrint != null) {
			throw new RuntimeException(Messages.getString("Issue.0")); //$NON-NLS-1$
		}
		this.fingerPrint = fingerPrint;
	}
	/**
	 * <DL>
	 * <DT><B>カテゴリ を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return カテゴリ 
	 */
	public String getCategory() {
		return this.category;
	}

	/**
	 * <DL>
	 * <DT><B>カテゴリを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param category カテゴリ
	 */
	public void setCategory( String category ) {
		this.category = category;
	}
	/**
	 * <DL>
	 * <DT><B>タイトル を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return タイトル 
	 */
	public String getTitle() {
		return this.title;
	}

	/**
	 * <DL>
	 * <DT><B>タイトルを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param title タイトル
	 */
	public void setTitle( String title ) {
		this.title = title;
	}
	/**
	 * <DL>
	 * <DT><B>詳細 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 詳細 
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * <DL>
	 * <DT><B>詳細を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param description 詳細
	 */
	public void setDescription( String description ) {
		this.description = description;
	}
	/**
	 * <DL>
	 * <DT><B>優先度 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 優先度 
	 */
	public String getPriority() {
		return this.priority;
	}

	/**
	 * <DL>
	 * <DT><B>優先度を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param priority 優先度
	 */
	public void setPriority( String priority ) {
		this.priority = priority;
	}
	/**
	 * <DL>
	 *  <DT><B>完了期限 に日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param deadline        完了期限 に指定する日時オブジェクト
	 */
	public void setDeadline( Date deadline ){
		if( deadline != null ){
			this.deadline = new Date( deadline.getTime() );
		}
	}

	/**
	 * <DL>
	 *  <DT><B>完了期限 に日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   完了期限 に指定するlong型のタイムスタンプ
	 */
	public void setDeadline( long timestamp ){
		this.deadline = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>完了期限 を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return 完了期限
	 */
	public Date getDeadline(){
		return this.deadline;
	}

	/**
	 * <DL>
	 *  <DT><B>完了期限 をlongのタイムスタンプで取得</B></DL>
	 *  <DD>完了期限 の日付情報をlongのタイムスタンプで取得します。
	 * 完了期限 がnullの場合、NullPointerExceptionが発生することに注意してください。</DD>
	 * </DL>
	 * @return 完了期限 のタイムスタンプ(long)
	 */
	public long getDeadlineTimestamp(){
		return this.deadline.getTime();
	}
	/**
	 * <DL>
	 * <DT><B>ステータス を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return ステータス 
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * <DL>
	 * <DT><B>ステータスを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param status ステータス
	 */
	public void setStatus( String status ) {
		this.status = status;
	}
	/**
	 * <DL>
	 * <DT><B>担当者 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 担当者 
	 */
	public String getAssigned() {
		return this.assigned;
	}

	/**
	 * <DL>
	 * <DT><B>担当者を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param assigned 担当者
	 */
	public void setAssigned( String assigned ) {
		this.assigned = assigned;
	}
	/**
	 * <DL>
	 * <DT><B>内緒のバグ を戻します。</B></B>
	 * <DD>内緒のバグをBooleanのプリミティブ型booleanで取得します。</DD>
	 * </DL>
	 * @return 内緒のバグ 
	 */
	public Boolean isSecretBug() {
		return this.secretBug;
	}

	/**
	 * <DL>
	 * <DT><B>内緒のバグ を戻します。</B></B>
	 * <DD>内緒のバグをBooleanのプリミティブ型booleanで取得します。</DD>
	 * </DL>
	 * @return 内緒のバグ 
	 */
	public Boolean getSecretBug() {
		return this.secretBug;
	}

	/**
	 * <DL>
	 * <DT><B>内緒のバグを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param secretBug 内緒のバグ
	 */
	public void setSecretBug( Boolean secretBug ) {
		this.secretBug = secretBug;
	}

	/**
	 * <DL>
	 * <DT><B>内緒のバグを設定します。</B></DT>
	 * <DD>内緒のバグをBooleanのプリミティブ型booleanで設定します。</DD>
	 * </DL>
	 * @param secretBug 内緒のバグ
	 */
	public void setSecretBug( boolean secretBug ) {
		this.secretBug = new Boolean( secretBug );
	}

	/**
	 * <DL>
	 * <DT><B>保留 を戻します。</B></B>
	 * <DD>保留をBooleanのプリミティブ型booleanで取得します。</DD>
	 * </DL>
	 * @return 保留 
	 */
	public Boolean isSuspend() {
		return this.suspend;
	}

	/**
	 * <DL>
	 * <DT><B>保留 を戻します。</B></B>
	 * <DD>保留をBooleanのプリミティブ型booleanで取得します。</DD>
	 * </DL>
	 * @return 保留 
	 */
	public Boolean getSuspend() {
		return this.suspend;
	}

	/**
	 * <DL>
	 * <DT><B>保留を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param suspend 保留
	 */
	public void setSuspend( Boolean suspend ) {
		this.suspend = suspend;
	}

	/**
	 * <DL>
	 * <DT><B>保留を設定します。</B></DT>
	 * <DD>保留をBooleanのプリミティブ型booleanで設定します。</DD>
	 * </DL>
	 * @param suspend 保留
	 */
	public void setSuspend( boolean suspend ) {
		this.suspend = new Boolean( suspend );
	}

	

	/**
	 * <DL>
	 * <DT><B>レコード作製者 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return レコード作製者 
	 */
	public String getCreateUser() {
		return this.createUser;
	}

	/**
	 * <DL>
	 * <DT><B>レコード作製者を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param createUser レコード作製者
	 */
	public void setCreateUser( String createUser ) {
		this.createUser = createUser;
	}
	/**
	 * <DL>
	 *  <DT><B>レコード作製タイムスタンプ に日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param createDate        レコード作製タイムスタンプ に指定する日時オブジェクト
	 */
	public void setCreateDate( Date createDate ){
		if( createDate != null ){
			this.createDate = new Date( createDate.getTime() );
		}
	}

	/**
	 * <DL>
	 *  <DT><B>レコード作製タイムスタンプ に日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   レコード作製タイムスタンプ に指定するlong型のタイムスタンプ
	 */
	public void setCreateDate( long timestamp ){
		this.createDate = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>レコード作製タイムスタンプ を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return レコード作製タイムスタンプ
	 */
	public Date getCreateDate(){
		return this.createDate;
	}

	/**
	 * <DL>
	 *  <DT><B>レコード作製タイムスタンプ をlongのタイムスタンプで取得</B></DL>
	 *  <DD>レコード作製タイムスタンプ の日付情報をlongのタイムスタンプで取得します。
	 * レコード作製タイムスタンプ がnullの場合、NullPointerExceptionが発生することに注意してください。</DD>
	 * </DL>
	 * @return レコード作製タイムスタンプ のタイムスタンプ(long)
	 */
	public long getCreateDateTimestamp(){
		return this.createDate.getTime();
	}


	
	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ に日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param updateDate        レコード更新タイムスタンプ に指定する日時オブジェクト
	 */
	public void setUpdateDate( Date updateDate ){
		if( updateDate != null ){
			this.updateDate = new Date( updateDate.getTime() );
		}
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ に日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   レコード更新タイムスタンプ に指定するlong型のタイムスタンプ
	 */
	public void setUpdateDate( long timestamp ){
		this.updateDate = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return レコード更新タイムスタンプ
	 */
	public Date getUpdateDate(){
		return this.updateDate;
	}

	/**
	 * <DL>
	 *  <DT><B>レコード更新タイムスタンプ をlongのタイムスタンプで取得</B></DL>
	 *  <DD>レコード更新タイムスタンプ の日付情報をlongのタイムスタンプで取得します。
	 * レコード更新タイムスタンプ がnullの場合、NullPointerExceptionが発生することに注意してください。</DD>
	 * </DL>
	 * @return レコード更新タイムスタンプ のタイムスタンプ(long)
	 */
	public long getUpdateDateTimestamp(){
		return this.updateDate.getTime();
	}

	/**
	 * <DL><DT><B>バージョン番号 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return version バージョン番号
	 */
	public Integer getVersion() {
		return this.version;
	}

	/**
	 * <DL><DT><B>バージョン番号を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param version バージョン番号。
	 */
	public void setVersion( Integer version ) {
		this.version = version;
	}

	/**
	 * <DL><DT><B>バージョン番号を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param version バージョン番号。
	 */
	public void setVersion( int version ) {
		this.version = new Integer(version);
	}

	/**
	 * <DL><DT><B>課題票種別 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 課題票種別
	 */
	public String getType() {
		return type;
	}

	/**
	 * <DL><DT><B>課題票種別を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param type 課題票種別。
	 */
	public void setType(String type) {
		this.type = type;
	}
	
	
	/**
	 * <DL>
	 *   <DT><B>課題票識別キー を戻します。</B></DT>
	 *   <DD>「課題票識別キー」とは{@link #getFingerPrint() fingerPrint}＋{@link #getType() Type}で構成されます。</DD>
	 * </DL>
	 * @return 課題票種別
	 */
	public String getKey() {
		return this.fingerPrint + this.type;
	}
	
	/**
	 * <DL>
	 *  <DT>{@link Attachment 添付ファイル}のリストをArrayListで返します。</DT>
	 *  <DD></DD>
	 * </DL>
	 * @return			添付ファイルのリスト
	 */
	public ArrayList getAttachmentList() {
		return attachmentList;
	}
	
	/**
	 * <DL>
	 *  <DT>{@link Attachment 添付ファイル}の配列を返します。</DT>
	 *  <DD></DD>
	 * </DL>
	 * @return			添付ファイルのリスト
	 */
	public Attachment[] getAttachments() {
		if(attachmentList==null || attachmentList.size()==0) {
			return null;
		}
		return (Attachment[])attachmentList.toArray(new Attachment[0]);
	}

	/**
	 * 
	 * <DL>
	 *  <DT>{@link Attachment 添付ファイル}のリストをArrayList型で格納します。</DT>
	 *  <DD></DD>
	 * </DL>
	 * @param			attachmentList			添付ファイルのリスト			
	 */
	public void setAttachmentList(ArrayList attachmentList) {
		this.attachmentList = attachmentList;
	}


	/**
	 * {@link CommentHistory コメント履歴配列}を型で返します。
	 * 
	 * @return		コメント履歴
	 */
	public CommentHistory[] getCommentHistories() {
		return commentHistory;
	}

	/**
	 * {@link CommentHistory コメント履歴配列}をArrayList型で格納します。
	 * 
	 * @param		commentHistory		コメント履歴
	 */
	public void setCommentHistories(CommentHistory[] commentHistory) {
		this.commentHistory = commentHistory;
	}


	/**
	 * {@link IssueHistory 課題票履歴配列}を返します。
	 *
	 * 
	 * @return		課題票履歴配列
	 */
	public IssueHistory[] getIssueHistories() {
		return issueHistory;
	}

	/**
	 * {@link IssueHistory 課題票履歴配列}をArrayList型で格納します。
	 *
	 * 
	 * @param		issueHistory		課題票履歴配列
	 */
	public void setIssueHistories(IssueHistory[] issueHistory) {
		this.issueHistory = issueHistory;
	}
	
	/**
	 * <DL><DT><B>自分が更新した回数 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 自分が更新した回数
	 */
	public int getUpdateCnt() {
		return updateCnt;
	}
	
	/**
	 * <DL><DT><B>自分が更新した回数を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param updateCnt 自分が更新した回数
	 */
	public void setUpdateCnt(int updateCnt) {
		this.updateCnt = updateCnt;
	}

	/**
	 * <DL><DT><B>投票情報を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return 投票情報
	 */
	public Vote[] getVotes() {
		return votes;
	}
	
	/**
	 * <DL><DT><B>投票情報を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param votes 投票情報
	 */
	public void setVotes(Vote[] votes) {
		this.votes = votes;
	}

	
	/**
	 * <DL>
	 *   <DT><B>同じ課題票であるかどうか比較します。</B></DT>
	 *   <DD>比較には{@link #getType() 課題票識別キー}を使います。
	 *       {@link #getFingerPrint() fingerPrint}＋{@link #getType() Type}が同一の場合はtrueを返します。<br>
	 *   </DD>
	 * </DL>
	 * 
	 * @param		obj			比較対象のインスタンス
	 * @return		true---当オブジェクトと指定のオブジェクトが同一。
	 *              false--当オブジェクトと指定のオブジェクトが同一でない。
	 * @see			java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if(obj==this) {
			return true;
		}

		// fingerprintがnullか空文字の場合はfalseを返す。
		if(fingerPrint == null || "".equals(fingerPrint)) {
			return false;
		}

		// Issueインスタンスかどうかを確認
		if(obj instanceof Issue) {
			Issue that = (Issue)obj;
			
			// fingerprint+typeを比較する。同じであればtrueを返し、それ以外はfalseを返す。
			return this.getKey().equals(that.getKey()); 
		}
		return false;
	}
	
	
	/*
	 *  (非 Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("{issueID="				).append(issueID);
		buf.append(", fingerPrint="			).append(fingerPrint);
		buf.append(", category="			).append(category);
		buf.append(", title="				).append(title);
		buf.append(", description="			).append(description);
		buf.append(", priority="			).append(priority);
		buf.append(", deadline="			).append(deadline);
		buf.append(", status="				).append(status);
		buf.append(", assigned="			).append(assigned);
		buf.append(", secretBug="			).append(secretBug);
		buf.append(", suspend="				).append(suspend);
		buf.append(", createUser="			).append(createUser);
		buf.append(", createDate="			).append(createDate);
		buf.append(", updateDate="			).append(updateDate);
		buf.append(", version="				).append(version);
		buf.append("}");
		return buf.toString();
	}
}