/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.beans.XMLEncoder;


/**
 * {@link XMLEncoder}を利用して課題票一覧をXMLに出力するためのJavaBeansクラスです。
 * {@link XMLEncoder}を利用するにはデフォルトコンストラクタが存在しなければなりません。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OutputIssues {

	/** 完了期限(0:完了期限に余裕のある課題　1:完了期限に迫った課題　2:完了期限を過ぎた課題) */
	private String deadline;
	
	/** 課題票ID */
	private String issueID;
	
	/** タイトル */
	private String title;
	
	/** カテゴリ */
	private String category;
	
	/** 優先度 */
	private String priority;
	
	/** ステータス(value) */
	private String statusValue;
	
	/** ステータス */
	private String status;
	
	/** 担当者 */
	private String assigned;
	
	/** 起票日時(yyyy/MM/dd HH:mm) */
	private String createDate;
	
	/** ヘッダ文字列 */
	private String header;
	
	/** フッタ文字列 */
	private String footer;
	
	/** レポート出力日時(yyyy/MM/dd HH:mm) */
	private String nowDate;
	
	/** 完了期限までの残り日数 */
	private String limit;
	
	/** 課題票件数 */
	private String issueNum;

	
	/**
	 * デフォルトコンストラクタです。
	 */
	public OutputIssues() {
	}


	/**
	 * @return assigned を戻します。
	 */
	public String getAssigned() {
		return assigned;
	}


	/**
	 * @param assigned 設定する assigned。
	 */
	public void setAssigned(String assigned) {
		this.assigned = assigned;
	}


	/**
	 * @return category を戻します。
	 */
	public String getCategory() {
		return category;
	}


	/**
	 * @param category 設定する category。
	 */
	public void setCategory(String category) {
		this.category = category;
	}


	/**
	 * @return createDate を戻します。
	 */
	public String getCreateDate() {
		return createDate;
	}


	/**
	 * @param createDate 設定する createDate。
	 */
	public void setCreateDate(String createDate) {
		this.createDate = createDate;
	}


	/**
	 * @return deadline を戻します。
	 */
	public String getDeadline() {
		return deadline;
	}


	/**
	 * @param deadline 設定する deadline。
	 */
	public void setDeadline(String deadline) {
		this.deadline = deadline;
	}


	/**
	 * @return footer を戻します。
	 */
	public String getFooter() {
		return footer;
	}


	/**
	 * @param footer 設定する footer。
	 */
	public void setFooter(String footer) {
		this.footer = footer;
	}


	/**
	 * @return header を戻します。
	 */
	public String getHeader() {
		return header;
	}


	/**
	 * @param header 設定する header。
	 */
	public void setHeader(String header) {
		this.header = header;
	}


	/**
	 * @return issueID を戻します。
	 */
	public String getIssueID() {
		return issueID;
	}


	/**
	 * @param issueID 設定する issueID。
	 */
	public void setIssueID(String issueID) {
		this.issueID = issueID;
	}


	/**
	 * @return issueNum を戻します。
	 */
	public String getIssueNum() {
		return issueNum;
	}


	/**
	 * @param issueNum 設定する issueNum。
	 */
	public void setIssueNum(String issueNum) {
		this.issueNum = issueNum;
	}


	/**
	 * @return limit を戻します。
	 */
	public String getLimit() {
		return limit;
	}


	/**
	 * @param limit 設定する limit。
	 */
	public void setLimit(String limit) {
		this.limit = limit;
	}


	/**
	 * @return nowDate を戻します。
	 */
	public String getNowDate() {
		return nowDate;
	}


	/**
	 * @param nowDate 設定する nowDate。
	 */
	public void setNowDate(String nowDate) {
		this.nowDate = nowDate;
	}


	/**
	 * @return priority を戻します。
	 */
	public String getPriority() {
		return priority;
	}


	/**
	 * @param priority 設定する priority。
	 */
	public void setPriority(String priority) {
		this.priority = priority;
	}
	
	
	/**
	 * @return statusValue を戻します。
	 */
	public String getStatusValue() {
		return statusValue;
	}


	/**
	 * @param statusValue 設定する。
	 */
	public void setStatusValue(String statusValue) {
		this.statusValue = statusValue;
	}


	/**
	 * @return status を戻します。
	 */
	public String getStatus() {
		return status;
	}


	/**
	 * @param status 設定する status。
	 */
	public void setStatus(String status) {
		this.status = status;
	}


	/**
	 * @return title を戻します。
	 */
	public String getTitle() {
		return title;
	}


	/**
	 * @param title 設定する title。
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	

}
