/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import java.util.List;

import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.IssueType;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.IssueChartDialog;
import jp.valtech.bts.util.IssueChartRender;
import jp.valtech.bts.ui.action.Messages;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.part.ViewPart;

/**
 * 統計グラフダイアログを開くアクションです。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OpenChartDlgAction extends Action {

	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("chart.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("chart_disable.gif"); 

	/** このアクションの呼び出しもとのビューオブジェクト */
	private ViewPart view;
	
	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public OpenChartDlgAction(ViewPart view) {
		super();
		this.view = view;

		setText(Messages.getString("OpenChartDlgAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("OpenChartDlgAction.1"));  //$NON-NLS-1$

		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}
	
	/**
	 * バグ累計グラフダイアログを開きます。
	 */
	public void run() {
		
		List chartIssueList;

		// 課題票一覧(種別がRのみ)を取得
		ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
		try {
			chartIssueList = issueModifyFacade.getByType(IssueType.RELEASE_VALUE);
			
		} catch (BtsDBException e) {
			MessageDialog.openError(BtsPlugin.getInstance().getShell()
								   , Messages.getString("OpenChartDlgAction.2") //$NON-NLS-1$
								   , Messages.getString("OpenChartDlgAction.3")); //$NON-NLS-1$
			return;
		}
		
		// 課題票リストが空の場合
		if(chartIssueList.size() == 0) {
			MessageDialog.openError( BtsPlugin.getInstance().getShell()
								   , Messages.getString("OpenChartDlgAction.4") //$NON-NLS-1$
								   , Messages.getString("OpenChartDlgAction.5")); //$NON-NLS-1$
			return;
		}
		
		// 日毎の発生バグと解決バグをカウントし、カウントをもとにグラフをPNGで出力
		IssueChartRender render = new IssueChartRender(chartIssueList);
		render.createChart();

		// ダイアログオープン
		IssueChartDialog issueChartDialog = new IssueChartDialog(view.getSite().getShell(), chartIssueList);
		issueChartDialog.open();
	}
}
